/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.json;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.mastercard.developer.json.GsonJsonEngine;
import com.mastercard.developer.json.JacksonJsonEngine;
import com.mastercard.developer.json.JettisonJsonEngine;
import com.mastercard.developer.json.JsonOrgJsonEngine;
import com.mastercard.developer.json.JsonSmartJsonEngine;
import com.mastercard.developer.utils.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class JsonEngine {
    private static final Pattern LAST_ELEMENT_IN_PATH_PATTERN = Pattern.compile(".*(\\['.*'\\])");

    public abstract JsonProvider getJsonProvider();

    public abstract Object parse(String var1);

    public static JsonEngine getDefault() {
        if (JsonEngine.isClassFound("com.fasterxml.jackson.databind.ObjectMapper")) {
            return new JacksonJsonEngine();
        }
        if (JsonEngine.isClassFound("org.codehaus.jettison.json.JSONObject")) {
            return new JettisonJsonEngine();
        }
        if (JsonEngine.isClassFound("org.json.JSONObject")) {
            return new JsonOrgJsonEngine();
        }
        if (JsonEngine.isClassFound("net.minidev.json.parser.JSONParser")) {
            return new JsonSmartJsonEngine();
        }
        if (JsonEngine.isClassFound("com.google.gson.Gson")) {
            return new GsonJsonEngine();
        }
        String message = "At least one of the following JSON library must be added to your classpath:\n* com.fasterxml.jackson.core:jackson-databind\n* net.minidev:json-smart\n* org.codehaus.jettison:jettison\n* org.json:json\n* com.google.code.gson:gson";
        throw new IllegalStateException(message);
    }

    public void addProperty(Object obj, String key, Object val) {
        this.getJsonProvider().setProperty(obj, (Object)key, val);
    }

    private static boolean isClassFound(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected static Object asPrimitiveValue(String string) {
        if ("true".equals(string) || "false".equals(string)) {
            return Boolean.valueOf(string);
        }
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }

    public String toJsonString(Object object) {
        if (null == object) {
            throw new IllegalStateException("Can't get a JSON string from a null object!");
        }
        if (this.isJsonPrimitive(object)) {
            return object.toString();
        }
        return this.getJsonProvider().toJson(object);
    }

    protected boolean isJsonPrimitive(Object jsonElement) {
        JsonProvider jsonProvider = this.getJsonProvider();
        return !jsonProvider.isMap(jsonElement) && !jsonProvider.isArray(jsonElement);
    }

    public boolean isJsonObject(Object jsonElement) {
        return this.getJsonProvider().isMap(jsonElement);
    }

    public boolean isNullOrEmptyJson(Object jsonElement) {
        return jsonElement == null || StringUtils.isNullOrEmpty(this.toJsonString(jsonElement)) || "{}".equals(this.toJsonString(jsonElement)) || Object.class.equals(jsonElement.getClass());
    }

    public Collection<String> getPropertyKeys(Object jsonElement) {
        if (this.isNullOrEmptyJson(jsonElement)) {
            return Collections.emptyList();
        }
        return this.getJsonProvider().getPropertyKeys(jsonElement);
    }

    public static String getParentJsonPath(String jsonPathString) {
        JsonPath jsonPath = JsonPath.compile((String)jsonPathString, (Predicate[])new Predicate[0]);
        String compiledPath = jsonPath.getPath();
        Matcher matcher = LAST_ELEMENT_IN_PATH_PATTERN.matcher(compiledPath);
        if (matcher.find()) {
            return compiledPath.replace(matcher.group(1), "");
        }
        throw new IllegalStateException(String.format("Unable to find parent for '%s'", jsonPathString));
    }

    public static String getJsonElementKey(String jsonPathString) {
        JsonPath jsonPath = JsonPath.compile((String)jsonPathString, (Predicate[])new Predicate[0]);
        String compiledPath = jsonPath.getPath();
        Matcher matcher = LAST_ELEMENT_IN_PATH_PATTERN.matcher(compiledPath);
        if (matcher.find()) {
            return matcher.group(1).replace("['", "").replace("']", "");
        }
        throw new IllegalStateException(String.format("Unable to find object key for '%s'", jsonPathString));
    }
}

