/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.eac.jcajce;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.eac.EACObjectIdentifiers;
import org.spongycastle.asn1.eac.ECDSAPublicKey;
import org.spongycastle.asn1.eac.PublicKeyDataObject;
import org.spongycastle.eac.EACException;
import org.spongycastle.eac.jcajce.DefaultEACHelper;
import org.spongycastle.eac.jcajce.EACHelper;
import org.spongycastle.eac.jcajce.NamedEACHelper;
import org.spongycastle.eac.jcajce.ProviderEACHelper;
import org.spongycastle.jce.spec.ECPublicKeySpec;
import org.spongycastle.math.ec.ECCurve;

public class JcaPublicKeyConverter {
    private EACHelper helper = new DefaultEACHelper();

    public JcaPublicKeyConverter setProvider(String providerName) {
        this.helper = new NamedEACHelper(providerName);
        return this;
    }

    public JcaPublicKeyConverter setProvider(Provider provider) {
        this.helper = new ProviderEACHelper(provider);
        return this;
    }

    public PublicKey getKey(PublicKeyDataObject publicKeyDataObject) throws EACException, InvalidKeySpecException {
        if (publicKeyDataObject.getUsage().on(EACObjectIdentifiers.id_TA_ECDSA)) {
            return this.getECPublicKeyPublicKey((ECDSAPublicKey)publicKeyDataObject);
        }
        org.spongycastle.asn1.eac.RSAPublicKey pubKey = (org.spongycastle.asn1.eac.RSAPublicKey)publicKeyDataObject;
        RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(pubKey.getModulus(), pubKey.getPublicExponent());
        try {
            KeyFactory factk = this.helper.createKeyFactory("RSA");
            return factk.generatePublic(pubKeySpec);
        }
        catch (NoSuchProviderException e) {
            throw new EACException("cannot find provider: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EACException("cannot find algorithm ECDSA: " + e.getMessage(), e);
        }
    }

    private PublicKey getECPublicKeyPublicKey(ECDSAPublicKey key) throws EACException, InvalidKeySpecException {
        KeyFactory factk;
        org.spongycastle.jce.spec.ECParameterSpec spec = this.getParams(key);
        ECCurve curve = spec.getCurve();
        org.spongycastle.math.ec.ECPoint point = curve.decodePoint(key.getPublicPointY());
        ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(point, spec);
        try {
            factk = this.helper.createKeyFactory("ECDSA");
        }
        catch (NoSuchProviderException e) {
            throw new EACException("cannot find provider: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EACException("cannot find algorithm ECDSA: " + e.getMessage(), e);
        }
        return factk.generatePublic((KeySpec)pubKeySpec);
    }

    private org.spongycastle.jce.spec.ECParameterSpec getParams(ECDSAPublicKey key) {
        if (!key.hasParameters()) {
            throw new IllegalArgumentException("Public key does not contains EC Params");
        }
        BigInteger p = key.getPrimeModulusP();
        ECCurve.Fp curve = new ECCurve.Fp(p, key.getFirstCoefA(), key.getSecondCoefB());
        org.spongycastle.math.ec.ECPoint G = curve.decodePoint(key.getBasePointG());
        BigInteger order = key.getOrderOfBasePointR();
        BigInteger coFactor = key.getCofactorF();
        org.spongycastle.jce.spec.ECParameterSpec ecspec = new org.spongycastle.jce.spec.ECParameterSpec((ECCurve)curve, G, order, coFactor);
        return ecspec;
    }

    public PublicKeyDataObject getPublicKeyDataObject(ASN1ObjectIdentifier usage, PublicKey publicKey) {
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey pubKey = (RSAPublicKey)publicKey;
            return new org.spongycastle.asn1.eac.RSAPublicKey(usage, pubKey.getModulus(), pubKey.getPublicExponent());
        }
        ECPublicKey pubKey = (ECPublicKey)publicKey;
        ECParameterSpec params = pubKey.getParams();
        return new ECDSAPublicKey(usage, ((ECFieldFp)params.getCurve().getField()).getP(), params.getCurve().getA(), params.getCurve().getB(), JcaPublicKeyConverter.convertPoint(JcaPublicKeyConverter.convertCurve(params.getCurve()), params.getGenerator(), false).getEncoded(), params.getOrder(), JcaPublicKeyConverter.convertPoint(JcaPublicKeyConverter.convertCurve(params.getCurve()), pubKey.getW(), false).getEncoded(), params.getCofactor());
    }

    private static org.spongycastle.math.ec.ECPoint convertPoint(ECCurve curve, ECPoint point, boolean withCompression) {
        return curve.createPoint(point.getAffineX(), point.getAffineY(), withCompression);
    }

    private static ECCurve convertCurve(EllipticCurve ec) {
        ECField field = ec.getField();
        BigInteger a = ec.getA();
        BigInteger b = ec.getB();
        if (field instanceof ECFieldFp) {
            return new ECCurve.Fp(((ECFieldFp)field).getP(), a, b);
        }
        throw new IllegalStateException("not implemented yet!!!");
    }
}

