/*
 * Decompiled with CFR 0.152.
 */
package com.macasaet.fernet;

import com.macasaet.fernet.Constants;
import com.macasaet.fernet.TokenValidationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Key {
    private final byte[] signingKey;
    private final byte[] encryptionKey;

    public Key(byte[] signingKey, byte[] encryptionKey) {
        if (signingKey == null || signingKey.length != 16) {
            throw new IllegalArgumentException("Signing key must be 128 bits");
        }
        if (encryptionKey == null || encryptionKey.length != 16) {
            throw new IllegalArgumentException("Encryption key must be 128 bits");
        }
        this.signingKey = Arrays.copyOf(signingKey, 16);
        this.encryptionKey = Arrays.copyOf(encryptionKey, 16);
    }

    public Key(byte[] concatenatedKeys) {
        this(Arrays.copyOfRange(concatenatedKeys, 0, 16), Arrays.copyOfRange(concatenatedKeys, 16, 32));
    }

    public Key(String string) {
        this(Constants.decoder.decode(string));
    }

    public static Key generateKey() {
        return Key.generateKey(new SecureRandom());
    }

    public static Key generateKey(SecureRandom random) {
        byte[] signingKey = new byte[16];
        random.nextBytes(signingKey);
        byte[] encryptionKey = new byte[16];
        random.nextBytes(encryptionKey);
        return new Key(signingKey, encryptionKey);
    }

    public byte[] sign(byte version, Instant timestamp, IvParameterSpec initializationVector, byte[] cipherText) {
        byte[] byArray;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(this.getTokenPrefixBytes() + cipherText.length);
        try {
            byArray = this.sign(version, timestamp, initializationVector, cipherText, byteStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        byteStream.close();
        return byArray;
    }

    public byte[] encrypt(byte[] payload, IvParameterSpec initializationVector) {
        SecretKeySpec encryptionKeySpec = this.getEncryptionKeySpec();
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (java.security.Key)encryptionKeySpec, initializationVector);
            return cipher.doFinal(payload);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("Unable to access cipher AES/CBC/PKCS5Padding: " + e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new IllegalStateException("Unable to initialise encryption cipher with algorithm " + encryptionKeySpec.getAlgorithm() + " and format " + encryptionKeySpec.getFormat() + ": " + e.getMessage(), e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException("Unable to encrypt data: " + e.getMessage(), e);
        }
    }

    protected byte[] decrypt(byte[] cipherText, IvParameterSpec initializationVector) {
        try {
            Cipher cipher = Cipher.getInstance(this.getCipherTransformation());
            cipher.init(2, (java.security.Key)this.getEncryptionKeySpec(), initializationVector);
            return cipher.doFinal(cipherText);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (BadPaddingException bpe) {
            throw new TokenValidationException("Invalid padding in token: " + bpe.getMessage(), bpe);
        }
    }

    public String serialise() {
        String string;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(32);
        try {
            this.writeTo(byteStream);
            string = this.getEncoder().encodeToString(byteStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe.getMessage(), ioe);
            }
        }
        byteStream.close();
        return string;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.getSigningKey());
        outputStream.write(this.getEncryptionKey());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.getSigningKey());
        result = 31 * result + Arrays.hashCode(this.getEncryptionKey());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Key)) {
            return false;
        }
        Key other = (Key)obj;
        return MessageDigest.isEqual(this.getSigningKey(), other.getSigningKey()) && MessageDigest.isEqual(this.getEncryptionKey(), other.getEncryptionKey());
    }

    /*
     * Exception decompiling
     */
    protected byte[] sign(byte version, Instant timestamp, IvParameterSpec initializationVector, byte[] cipherText, ByteArrayOutputStream byteStream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected java.security.Key getSigningKeySpec() {
        return new SecretKeySpec(this.getSigningKey(), this.getSigningAlgorithm());
    }

    protected SecretKeySpec getEncryptionKeySpec() {
        return new SecretKeySpec(this.getEncryptionKey(), this.getEncryptionAlgorithm());
    }

    protected byte[] getSigningKey() {
        return this.signingKey;
    }

    protected byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    protected int getTokenPrefixBytes() {
        return 25;
    }

    protected String getSigningAlgorithm() {
        return "HmacSHA256";
    }

    protected String getEncryptionAlgorithm() {
        return "AES";
    }

    protected Base64.Encoder getEncoder() {
        return Constants.encoder;
    }

    protected String getCipherTransformation() {
        return "AES/CBC/PKCS5Padding";
    }
}

