/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzLY;
import com.aspose.words.internal.zzWBl;
import com.aspose.words.internal.zzWEK;
import com.aspose.words.internal.zzWML;
import com.aspose.words.internal.zzXFa;
import com.aspose.words.internal.zzYFS;
import com.aspose.words.internal.zzZ2;
import com.aspose.words.zzZYC;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zz92;
    private zzZYC zzZFg;

    Watermark(Document doc, zzZYC watermarkProvider) {
        this.zz92 = doc;
        this.zzZFg = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzX13(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzXWJ(text, textWatermarkOptions, this.zz92);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzYFS.zzVOH((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zz92, 75);
        shape.getImageData().setImage(image);
        this.zzXWJ(shape, options, this.zz92);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzYFS.zzVOH((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zz92, 75);
        shape.getImageData().setImage(imagePath);
        this.zzXWJ(shape, options, this.zz92);
    }

    public final int getType() {
        Shape shape = this.zzZFg.get();
        if (shape == null) {
            return 2;
        }
        shape.zzWFs();
        if (shape.zzY2B()) {
            return 0;
        }
        if (shape.zzkw()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzZFg.add(shape);
    }

    public final void remove() {
        this.zzZFg.remove();
    }

    private static void zzX13(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzWML.zzHi(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzYFS.zzXWJ(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzXWJ(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzVOH(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzWOu(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzVOH(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzXmY() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzWle()) / d2) > (double)(f = pageSetup.zzWGF())) {
            d = (double)f / d3;
        }
        shape.zzWmP(zzWEK.zzYUy(d2 * d, 2, zzWBl.zzWsA));
        shape.zzZ99(zzWEK.zzYUy(d3 * d, 2, zzWBl.zzWsA));
    }

    private Shape zzXWJ(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzXWJ(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzWOu(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzXWJ(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzXY4() ? 1.0f : textWatermarkOptions.getFontSize();
        zzLY zzLY2 = document.zzVSg().zzYUy(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzLY2.zzWhp(shape.getTextPath().getText());
        if (textWatermarkOptions.zzXY4()) {
            l = Watermark.zzXWJ(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzWmP(zzWEK.zzYUy(Float.intBitsToFloat(n), 2, zzWBl.zzWsA));
        shape.zzZ99(zzWEK.zzYUy(zzZ2.zzXVh(l), 2, zzWBl.zzWsA));
    }

    private static long zzXWJ(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzWle();
        float f2 = pageSetup.zzWGF();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzZ2.zzXVh(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzZ2.zzY2G(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzZ2.zzXVh(l) >= Float.intBitsToFloat(n)) {
            return zzZ2.zzY2G(f2 / f3, f2);
        }
        float f6 = f;
        return zzZ2.zzY2G(f6, f6 * f3);
    }

    private static void zzWOu(Shape shape, String string) {
        shape.setName(zzXFa.zzVOH("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

