/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzNM;
import com.aspose.words.internal.zzVL;
import com.aspose.words.internal.zzWCz;
import com.aspose.words.internal.zzWPc;
import com.aspose.words.internal.zzWWj;
import com.aspose.words.internal.zzXFa;
import com.aspose.words.internal.zzXVB;
import com.aspose.words.internal.zzXrv;
import com.aspose.words.internal.zzYFS;
import com.aspose.words.internal.zzZVn;
import com.aspose.words.internal.zzZn0;
import com.aspose.words.internal.zzZpv;
import com.aspose.words.zzDT;
import com.aspose.words.zzVP7;
import com.aspose.words.zzVWl;
import com.aspose.words.zzWGa;
import com.aspose.words.zzWhf;
import com.aspose.words.zzWqn;
import com.aspose.words.zzXtO;
import com.aspose.words.zzZ1J;
import com.aspose.words.zzZ9O;
import com.aspose.words.zzZw1;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzXWJ(zzNM zzNM2, zzNM zzNM3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzYFS.zzVOH((Object)zzNM2, "srcStream");
        zzYFS.zzVOH((Object)zzNM3, "dstStream");
        zzYFS.zzVOH((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzVOH(zzNM2, zzNM3, certificateHolder, signOptions);
        zzNM3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzXWJ(zzNM.zzVOH(srcStream), (zzNM)zzNM.zzYUy(dstStream), certHolder, signOptions);
    }

    private static void zzVOH(zzNM zzNM2, zzNM zzNM3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzYUy(digitalSignature);
        }
        if (zzZ1J.zzZma(zzNM2)) {
            DigitalSignatureUtil.zzXWJ(zzNM2, zzNM3, digitalSignature, true);
            return;
        }
        zzZ1J zzZ1J2 = new zzZ1J();
        zzNM zzNM4 = zzNM2;
        zzZ1J zzZ1J3 = zzZ1J2;
        FileFormatInfo fileFormatInfo = zzZ1J2.zzVOH(zzNM4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzWCz zzWCz2 = new zzWCz(zzNM2);
                int n = fileFormatInfo.zzm4() == 1 ? 1 : 2;
                zzWhf.zzXWJ(zzWCz2, digitalSignature, n);
                zzNM3.zzVRg(0L);
                zzWCz2.zzZjo(zzNM3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzXWJ(fileFormatInfo.zza(), zzNM3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzXWJ(zzNM2, zzNM3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzXWJ(zzNM2, zzNM3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzYFS.zzVOH(srcFileName, "srcFileName");
        zzYFS.zzVOH(dstFileName, "dstFileName");
        try (zzZpv zzZpv2 = zzYFS.zzVOH(srcFileName, 3, 1);){
            try (zzZpv zzZpv3 = zzYFS.zzVOH(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzXWJ((zzNM)zzZpv2, (zzNM)zzZpv3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzWPc zzWPc2 = zzNM.zzYUy(dstStream);
        zzNM zzNM2 = zzNM.zzVOH(srcStream);
        DigitalSignatureUtil.zzXWJ(zzNM2, (zzNM)zzWPc2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzZpv zzZpv2 = zzYFS.zzVOH(srcFileName, 3, 1);){
            try (zzZpv zzZpv3 = zzYFS.zzVOH(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzuE(zzZpv2, zzZpv3);
            }
            return;
        }
    }

    private static void zzuE(zzNM zzNM2, zzNM zzNM3) throws Exception {
        zzZ1J zzZ1J2 = new zzZ1J();
        zzNM zzNM4 = zzNM2;
        zzZ1J zzZ1J3 = zzZ1J2;
        FileFormatInfo fileFormatInfo = zzZ1J2.zzVOH(zzNM4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzWCz zzWCz2 = new zzWCz(zzNM2);
                zzWCz2.zzZaI().zzXeA("_xmlsignatures");
                zzWCz2.zzZaI().zzXeA("_signatures");
                zzNM3.zzWZH(0L);
                zzWCz2.zzZjo(zzNM3);
                zzNM zzNM5 = zzNM3;
                zzNM5.zzVRg(zzNM5.zzWI6());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzZVn zzZVn2 = new zzZVn(zzNM2);
                zzVL zzVL2 = zzZVn2.zzXWJ(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzVL2 != null) {
                    for (zzWWj zzWWj2 : zzVL2.zzW1D()) {
                        String string = zzVL2.zzXWJ(zzWWj2);
                        zzZVn2.zzXAJ().remove(string);
                    }
                    zzZVn2.zzXAJ().remove(zzVL2.getName());
                    zzWWj zzWWj3 = zzZVn2.zzW1D().zzWuz("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzZVn2.zzW1D().remove(zzWWj3.getId());
                    zzZVn2.zzYq1();
                }
                zzNM3.zzWZH(0L);
                zzZVn2.zzZjo(zzNM3);
                zzNM zzNM6 = zzNM3;
                zzNM6.zzVRg(zzNM6.zzWI6());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzuE(zzNM.zzVOH(srcStream), zzNM.zzYUy(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzZpv zzZpv2 = zzYFS.zzVOH(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzXeY(zzZpv2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzXeY(zzNM zzNM2) throws Exception {
        if (zzZ1J.zzZma(zzNM2)) {
            return DigitalSignatureUtil.zzYKF(zzNM2);
        }
        zzZ1J zzZ1J2 = new zzZ1J();
        zzNM zzNM3 = zzNM2;
        zzZ1J zzZ1J3 = zzZ1J2;
        FileFormatInfo fileFormatInfo = zzZ1J2.zzVOH(zzNM3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzNM2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzXeY(zzNM.zzVOH(stream));
    }

    static zzXVB zzXWJ(zzWCz zzWCz2, String string) throws Exception {
        zzWGa zzWGa2 = new zzWGa(zzWCz2);
        if (zzWGa2.zzWva()) {
            zzXVB zzXVB2 = zzWGa2.zzWGa(string);
            return zzXVB2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzWR9(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzXFa.zzVOH("Unexpected digest algorithm: {0}.", n));
    }

    static String zzJX(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzWR9(n);
    }

    private static void zzXWJ(zzNM zzNM2, zzNM zzNM3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzZVn zzZVn2 = new zzZVn(zzNM2);
        zzVWl zzVWl2 = bl ? new zzXtO(zzZVn2) : new zzZw1(zzZVn2);
        zzVWl2.zzVOH(digitalSignature);
        zzNM3.zzVRg(0L);
        zzZVn2.zzZjo(zzNM3);
    }

    private static void zzXWJ(zzNM zzNM2, zzNM zzNM3, DigitalSignature digitalSignature) throws Exception {
        zzVP7 zzVP72 = new zzVP7(zzNM2);
        zzDT zzDT2 = new zzDT(zzVP72);
        zzDT2.zzVOH(digitalSignature);
        zzNM3.zzVRg(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzNM zzNM4 = zzNM3;
        zzVP7 zzVP73 = zzVP72;
        zzVP73.zzXWJ(zzNM4, string, null);
    }

    private static void zzXWJ(zzWCz zzWCz2, zzNM zzNM2, DigitalSignature digitalSignature, String string) throws Exception {
        zzXVB zzXVB2 = DigitalSignatureUtil.zzXWJ(zzWCz2, string);
        zzXVB zzXVB3 = new zzXVB();
        DigitalSignatureUtil.zzXWJ((zzNM)zzXVB2, (zzNM)zzXVB3, digitalSignature, false);
        zzWCz zzWCz3 = zzWGa.zzYUy(zzXVB3, string);
        zzWCz3.zzZjo(zzNM2);
    }

    private static DigitalSignatureCollection zzYKF(zzNM zzNM2) throws Exception {
        zzNM2.zzWZH(0L);
        zzZVn zzZVn2 = new zzZVn(zzNM2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzVL zzVL2 = zzZVn2.zzXWJ(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzVL2 != null) {
            for (zzWWj zzWWj2 : zzVL2.zzW1D()) {
                String string = zzVL2.zzXWJ(zzWWj2);
                zzVL zzVL3 = zzZVn2.zzoc(string);
                zzVL zzVL4 = zzZVn2.zzXWJ(zzVL3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzXrv zzXrv2 = zzZn0.zzXPQ(zzVL4.zzfl().zzZ65());
                zzWqn.zzXWJ(zzVL3.zzZh9(), zzXrv2, new zzZ9O(zzZVn2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

