/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzYFS;
import com.aspose.words.internal.zzYff;
import com.aspose.words.zz8b;
import com.aspose.words.zzVTl;
import com.aspose.words.zzWDy;
import com.aspose.words.zzWWo;
import com.aspose.words.zzWYT;
import com.aspose.words.zzX87;
import com.aspose.words.zzY9H;
import com.aspose.words.zzYF9;
import com.aspose.words.zzYdG;
import com.aspose.words.zzZDV;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzZDV zzZdz;

    ChartSeriesCollection(zzZDV dmlChart) {
        this.zzZdz = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZdz.zzCL().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZdz.zzCL().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZdz.zzCL().removeAt(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZdz.zzCL().clear();
        this.zzoc(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXWJ(seriesName, values);
        chartSeries.zz9Z().zzuE(ChartSeriesCollection.zzXYg(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXWJ(seriesName, yValues);
        chartSeries.zz9Z().zzuE(ChartSeriesCollection.zzuE(xValues));
        return chartSeries;
    }

    private ChartSeries zzXWJ(String string, zzYff[] zzYffArray, double[] dArray) {
        if (zzYffArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzYffArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzYffArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXWJ(string, dArray);
        chartSeries.zz9Z().zzuE(ChartSeriesCollection.zzXWJ(zzYffArray));
        if (!this.zzZdz.zzZqo()) {
            this.zzoc(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzXWJ(seriesName, zzYff.zzXWJ(dates), values);
    }

    private void zzoc(boolean bl) {
        zzYF9 zzYF92 = zzYFS.zzXWJ((Object)this.zzZdz, zzYF9.class);
        if (zzYF92 != null && zzYF92.zzW0y().zzXto()) {
            zzYF92.zzW0y().zzX9M().zzXYg(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzZdz.zzYNP() != 15) {
            this.zzZdz.zzXNS(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzXWJ(seriesName, yValues);
        chartSeries.zzW0S().zzWxr().zzXYg(3, this.zzZdz.zzKq());
        chartSeries.zz9Z().zzuE(ChartSeriesCollection.zzuE(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzZ8A().zzuE(ChartSeriesCollection.zzuE(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzXWJ(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzZdz);
        chartSeries.setName(string);
        this.zzVPR(chartSeries);
        chartSeries.zzY9H(this.zzZdz.zzZEQ().zzY5r() + 1);
        chartSeries.zzWlO(this.zzZdz.zzZEQ().zzSo() + 1);
        chartSeries.zzYxv().zzuE(ChartSeriesCollection.zzuE(dArray));
        this.zzZdz.zzZCZ().zzaq();
        this.zzZdz.zzCL().zzXYe(chartSeries);
        return chartSeries;
    }

    private void zzVPR(ChartSeries chartSeries) {
        chartSeries.zzW0S().zzWxr().zzXYg(5, new zzWDy());
        switch (this.zzZdz.zzYNP()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzXWJ(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzXWJ(chartSeries, 5);
                ChartSeriesCollection.zzXMa(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzXWJ(chartSeries, 1);
                ChartSeriesCollection.zzXMa(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzZcl(chartSeries);
            }
        }
    }

    private static void zzZcl(ChartSeries chartSeries) {
        zzWDy zzWDy2 = new zzWDy();
        zzWDy2.setOutline(new zz8b());
        zzWWo zzWWo2 = new zzWWo();
        zzWWo2.zzYkN(1);
        zzWDy2.getOutline().setFill(new zzWYT(zzWWo2));
        zzWDy2.getOutline().zzoc(19050.0);
        chartSeries.zzW0S().zzWxr().zzXYg(5, zzWDy2);
    }

    private static void zzXMa(ChartSeries chartSeries) {
        zzWDy zzWDy2 = new zzWDy();
        zzWDy2.setOutline(new zz8b());
        zzWDy2.getOutline().setFill(new zzX87());
        zzWDy2.getOutline().setEndCap(0);
        zzWDy2.getOutline().zzoc(19050.0);
        chartSeries.zzW0S().zzWxr().zzXYg(5, zzWDy2);
    }

    private static void zzXWJ(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzWBM());
        chartMarker.zzY36().zzXYg(0, n);
        chartSeries.zzW0S().zzWxr().zzXYg(4, chartMarker);
    }

    private static zzVTl zzuE(double[] dArray) {
        int n = 0;
        zzVTl zzVTl2 = new zzVTl(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzVTl2.zzYGR(new zzY9H(n, d, "General"));
            }
            ++n;
        }
        zzVTl2.zzZA6(dArray.length);
        return zzVTl2;
    }

    private static zzVTl zzXWJ(zzYff[] zzYffArray) {
        int n = 0;
        zzVTl zzVTl2 = new zzVTl(2);
        zzYff[] zzYffArray2 = zzYffArray;
        int n2 = zzYffArray.length;
        for (int i = 0; i < n2; ++i) {
            zzYff zzYff2 = zzYffArray2[i];
            zzVTl2.zzYGR(new zzY9H(n++, zzYff2.zzZzh(), "m/d/yyyy"));
        }
        zzVTl2.zzZA6(zzYffArray.length);
        return zzVTl2;
    }

    private static zzVTl zzXYg(String[] stringArray) {
        int n = 0;
        zzVTl zzVTl2 = new zzVTl(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzVTl2.zzYGR(new zzYdG(n++, string));
        }
        zzVTl2.zzZA6(stringArray.length);
        return zzVTl2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZdz.zzCL().getCount();
    }
}

