/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzYFS;
import com.aspose.words.zzTl;
import com.aspose.words.zzWYe;
import com.aspose.words.zzWqD;
import com.aspose.words.zzXRj;
import com.aspose.words.zzXSw;
import com.aspose.words.zzXkA;
import com.aspose.words.zzZC7;
import com.aspose.words.zzZKy;
import com.aspose.words.zzZWD;
import com.aspose.words.zzZcw;

public class Cell
extends CompositeNode<Node>
implements zzWYe,
zzZKy {
    private zzXkA zzY7K;
    private CellFormat zzZ78;
    private ParagraphCollection zzXS2;
    private TableCollection zzLN;

    public Cell(DocumentBase doc) {
        this(doc, new zzXkA());
    }

    Cell(DocumentBase doc, zzXkA cellPr) {
        super(doc);
        this.zzY7K = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzZ5q() {
        return (Cell)this.zzXUs();
    }

    public Row getParentRow() {
        return (Row)this.zzZ7M();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzYgD() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzYUy(this, true);
        }
        return -1;
    }

    final int zzYOi() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzYOi();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzZ78 == null) {
            this.zzZ78 = new CellFormat(this);
        }
        return this.zzZ78;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzXS2 == null) {
            this.zzXS2 = new ParagraphCollection(this);
        }
        return this.zzXS2;
    }

    public TableCollection getTables() {
        if (this.zzLN == null) {
            this.zzLN = new TableCollection(this);
        }
        return this.zzLN;
    }

    final zzXkA zzW6Y() {
        return this.zzY7K;
    }

    final void zzXWJ(zzXkA zzXkA2) {
        this.zzY7K = zzXkA2;
    }

    @Override
    final Node zzXWJ(boolean bl, zzXSw zzXSw2) {
        zzXkA zzXkA2;
        Cell cell = (Cell)super.zzXWJ(bl, zzXSw2);
        zzXkA zzXkA3 = this.zzY7K;
        cell.zzY7K = zzXkA2 = (zzXkA)zzXkA3.zzQN();
        cell.zzZ78 = null;
        cell.zzXS2 = null;
        cell.zzLN = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzXWJ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzVOH(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzZWD.zzY2G(this);
    }

    @Override
    final boolean zzYGR(Node node) {
        return zzWqD.zz1K(node);
    }

    final int zzY9k() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzXUs();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzY7K.zz8O(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzY7K.zz8O(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzXRj zzXRj2 = zzYFS.zzXWJ(object, zzXRj.class);
        if (zzXRj2 != null && zzXRj2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzZeG(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzXkA.zzXTK(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzY7K.zzZcl(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzY7K.clear();
    }

    private Object zzZeG(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzYFS.zzXWJ((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzXWJ(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzTl getInsertRevision() {
        Cell cell = this;
        return cell.zzY7K.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzTl value) {
        Cloneable cloneable = this;
        zzTl zzTl2 = value;
        cloneable = cloneable.zzY7K;
        ((zzZcw)cloneable).zzZcl(14, zzTl2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzTl getDeleteRevision() {
        Cell cell = this;
        return cell.zzY7K.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzTl value) {
        Cloneable cloneable = this;
        zzTl zzTl2 = value;
        cloneable = cloneable.zzY7K;
        ((zzZcw)cloneable).zzZcl(12, zzTl2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZC7 getMoveFromRevision() {
        Cell cell = this;
        return cell.zzY7K.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzZC7 value) {
        Cloneable cloneable = this;
        zzZC7 zzZC72 = value;
        cloneable = cloneable.zzY7K;
        ((zzZcw)cloneable).zzZcl(13, zzZC72);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZC7 getMoveToRevision() {
        Cell cell = this;
        return cell.zzY7K.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzZC7 value) {
        Cloneable cloneable = this;
        zzZC7 zzZC72 = value;
        cloneable = cloneable.zzY7K;
        ((zzZcw)cloneable).zzZcl(15, zzZC72);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzY7K.remove(13);
        cell = this;
        cell.zzY7K.remove(15);
    }

    final zzXkA zzYjg(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzXkA zzXkA2 = new zzXkA();
        this.zzXWJ(3120, zzXkA2);
        this.zzXWJ(3140, zzXkA2);
        this.zzXWJ(3110, zzXkA2);
        this.zzXWJ(3130, zzXkA2);
        this.zzXWJ(3090, zzXkA2);
        this.zzXWJ(3100, zzXkA2);
        this.zzXWJ(3070, zzXkA2);
        this.zzXWJ(3080, zzXkA2);
        if (bl && (tableStyle = zzYFS.zzXWJ((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzVOH(this, zzXkA2);
        }
        this.zzY7K.zzVOH((zzZcw)zzXkA2);
        return zzXkA2;
    }

    private void zzXWJ(int n, zzXkA zzXkA2) {
        zzXkA2.zzZcl(n, this.fetchInheritedCellAttr(n));
    }
}

