/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.uri.JsUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJsUriManager
implements JsUriManager {
    static final String JS_HOST_PARAM = "gadgets.uri.js.host";
    static final String JS_PATH_PARAM = "gadgets.uri.js.path";
    static final JsUriManager.JsUri INVALID_URI = new JsUriManager.JsUri(UriStatus.BAD_URI, Lists.newArrayList());
    protected static final String JS_SUFFIX = ".js";
    protected static final String JS_DELIMITER = ":";
    private final ContainerConfig config;
    private final JsUriManager.Versioner versioner;

    @Inject
    public DefaultJsUriManager(ContainerConfig config, JsUriManager.Versioner versioner) {
        this.config = config;
        this.versioner = versioner;
    }

    @Override
    public Uri makeExternJsUri(Gadget gadget, Collection<String> extern) {
        String container = gadget.getContext().getContainer();
        String jsHost = this.getReqConfig(container, JS_HOST_PARAM);
        String jsPathBase = this.getReqConfig(container, JS_PATH_PARAM);
        UriBuilder uri = new UriBuilder(Uri.parse((String)jsHost));
        StringBuilder jsPath = new StringBuilder(jsPathBase);
        if (!jsPathBase.endsWith("/")) {
            jsPath.append('/');
        }
        jsPath.append(DefaultJsUriManager.addJsLibs(extern));
        jsPath.append(JS_SUFFIX);
        uri.setPath(jsPath.toString());
        uri.addQueryParameter(UriCommon.Param.CONTAINER.getKey(), container);
        uri.addQueryParameter(UriCommon.Param.NO_CACHE.getKey(), gadget.getContext().getIgnoreCache() ? "1" : "0");
        uri.addQueryParameter(UriCommon.Param.DEBUG.getKey(), gadget.getContext().getDebug() ? "1" : "0");
        uri.addQueryParameter(UriCommon.Param.CONTAINER_MODE.getKey(), gadget.getContext().getRenderingContext() == RenderingContext.CONTAINER ? "1" : "0");
        if (this.addGadgetUri()) {
            uri.addQueryParameter(UriCommon.Param.URL.getKey(), gadget.getSpec().getUrl().toString());
        }
        if (this.versioner != null && !gadget.getContext().getIgnoreCache()) {
            uri.addQueryParameter(UriCommon.Param.VERSION.getKey(), this.versioner.version(gadget.getContext().getUrl(), container, extern));
        }
        return uri.toUri();
    }

    @Override
    public JsUriManager.JsUri processExternJsUri(Uri uri) throws GadgetException {
        String container = uri.getQueryParameter(UriCommon.Param.CONTAINER.getKey());
        if (container == null) {
            container = "default";
        }
        this.getReqConfig(container, JS_HOST_PARAM);
        String jsPrefix = this.getReqConfig(container, JS_PATH_PARAM);
        String host = uri.getAuthority();
        if (host == null) {
            this.issueUriFormatError("Unexpected: Js Uri has no host");
            return INVALID_URI;
        }
        String path = uri.getPath();
        if (path == null) {
            this.issueUriFormatError("Unexpected: Js Uri has no path");
            return INVALID_URI;
        }
        if (!path.startsWith(jsPrefix)) {
            this.issueUriFormatError("Js Uri path invalid, expected prefix: " + jsPrefix + ", is: " + path);
            return INVALID_URI;
        }
        if ((path = path.substring(jsPrefix.length())).endsWith(JS_SUFFIX)) {
            path = path.substring(0, path.length() - JS_SUFFIX.length());
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        Collection<String> libs = DefaultJsUriManager.getJsLibs(path);
        UriStatus status = UriStatus.VALID_UNVERSIONED;
        String version = uri.getQueryParameter(UriCommon.Param.VERSION.getKey());
        if (version != null && this.versioner != null) {
            Uri gadgetUri = null;
            String gadgetParam = uri.getQueryParameter(UriCommon.Param.URL.getKey());
            if (gadgetParam != null) {
                gadgetUri = Uri.parse((String)gadgetParam);
            }
            status = this.versioner.validate(gadgetUri, container, libs, version);
        }
        return new JsUriManager.JsUri(status, libs);
    }

    static String addJsLibs(Collection<String> extern) {
        return StringUtils.join(extern, (String)JS_DELIMITER);
    }

    static Collection<String> getJsLibs(String path) {
        return Arrays.asList(StringUtils.split((String)path, (String)JS_DELIMITER));
    }

    private String getReqConfig(String container, String key) {
        String ret = this.config.getString(container, key);
        if (ret == null && (ret = this.config.getString("default", key)) == null) {
            throw new RuntimeException("Container '" + container + "' missing config for required param: " + key);
        }
        return ret;
    }

    protected void issueUriFormatError(String err) throws GadgetException {
        throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, err, 400);
    }

    protected boolean addGadgetUri() {
        return false;
    }
}

