/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.uri.ConcatUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConcatUriManager
implements ConcatUriManager {
    public static final String CONCAT_HOST_PARAM = "gadgets.uri.concat.host";
    public static final String CONCAT_PATH_PARAM = "gadgets.uri.concat.path";
    public static final String CONCAT_JS_SPLIT_PARAM = "gadgets.uri.concat.js.splitToken";
    public static final String CONCAT_JS_EVAL_TPL = "eval(%s['%s']);";
    private static final ConcatUriManager.ConcatUri BAD_URI = new ConcatUriManager.ConcatUri(UriStatus.BAD_URI, null, null, null, null);
    private static final Integer START_INDEX = 1;
    private final ContainerConfig config;
    private final ConcatUriManager.Versioner versioner;
    private boolean strictParsing;

    @Inject
    public DefaultConcatUriManager(ContainerConfig config, @Nullable ConcatUriManager.Versioner versioner) {
        this.config = config;
        this.versioner = versioner;
    }

    @Inject(optional=true)
    public void setUseStrictParsing(@Named(value="shindig.uri.concat.use-strict-parsing") boolean useStrict) {
        this.strictParsing = useStrict;
    }

    @Override
    public List<ConcatUriManager.ConcatData> make(List<ConcatUriManager.ConcatUri> resourceUris, boolean isAdjacent) {
        ArrayList concatUris = Lists.newArrayListWithCapacity((int)resourceUris.size());
        if (resourceUris.isEmpty()) {
            return concatUris;
        }
        ConcatUriManager.ConcatUri exemplar = resourceUris.get(0);
        String container = exemplar.getContainer();
        List<String> versions = null;
        ArrayList batches = Lists.newArrayListWithCapacity((int)resourceUris.size());
        for (ConcatUriManager.ConcatUri ctx : resourceUris) {
            batches.add(ctx.getBatch());
        }
        if (this.versioner != null) {
            versions = this.versioner.version(batches, container);
        }
        Iterator versionIt = versions != null ? versions.iterator() : null;
        for (ConcatUriManager.ConcatUri ctx : resourceUris) {
            String version = versionIt != null ? (String)versionIt.next() : null;
            concatUris.add(this.makeConcatUri(ctx, isAdjacent, version));
        }
        return concatUris;
    }

    private ConcatUriManager.ConcatData makeConcatUri(ConcatUriManager.ConcatUri ctx, boolean isAdjacent, String version) {
        if (!isAdjacent && ctx.getType() != ConcatUriManager.Type.JS) {
            throw new UnsupportedOperationException("Split concatenation only supported for JS");
        }
        UriBuilder uriBuilder = ctx.makeQueryParams(null, version);
        String concatHost = this.getReqVal(ctx.getContainer(), CONCAT_HOST_PARAM);
        String concatPath = this.getReqVal(ctx.getContainer(), CONCAT_PATH_PARAM);
        uriBuilder.setAuthority(concatHost);
        uriBuilder.setPath(concatPath);
        uriBuilder.addQueryParameter(UriCommon.Param.TYPE.getKey(), ctx.getType().getType());
        List<Uri> resourceUris = ctx.getBatch();
        HashMap snippets = Maps.newHashMapWithExpectedSize((int)resourceUris.size());
        String splitParam = this.config.getString(ctx.getContainer(), CONCAT_JS_SPLIT_PARAM);
        boolean doSplit = false;
        if (!isAdjacent && splitParam != null && !"false".equalsIgnoreCase(splitParam)) {
            uriBuilder.addQueryParameter(UriCommon.Param.JSON.getKey(), splitParam);
            doSplit = true;
        }
        Integer i = (int)START_INDEX;
        for (Uri resource : resourceUris) {
            uriBuilder.addQueryParameter(i.toString(), resource.toString());
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            if (!doSplit) continue;
            snippets.put(resource, DefaultConcatUriManager.getJsSnippet(splitParam, resource));
        }
        return new ConcatUriManager.ConcatData(uriBuilder.toUri(), snippets);
    }

    static String getJsSnippet(String splitParam, Uri resource) {
        return String.format(CONCAT_JS_EVAL_TPL, splitParam, StringEscapeUtils.escapeJavaScript((String)resource.toString()));
    }

    private String getReqVal(String container, String key) {
        String val = this.config.getString(container, key);
        if (val == null) {
            throw new RuntimeException("Missing required config '" + key + "' for container: " + container);
        }
        return val;
    }

    @Override
    public ConcatUriManager.ConcatUri process(Uri uri) {
        String version;
        String container = uri.getQueryParameter(UriCommon.Param.CONTAINER.getKey());
        if (this.strictParsing && container == null) {
            return BAD_URI;
        }
        if (this.strictParsing) {
            String concatHost = this.getReqVal(container, CONCAT_HOST_PARAM);
            String concatPath = this.getReqVal(container, CONCAT_PATH_PARAM);
            if (!uri.getAuthority().equalsIgnoreCase(concatHost) || !uri.getPath().equals(concatPath)) {
                return BAD_URI;
            }
        }
        UriStatus status = UriStatus.VALID_UNVERSIONED;
        LinkedList uris = Lists.newLinkedList();
        ConcatUriManager.Type type = ConcatUriManager.Type.fromType(uri.getQueryParameter(UriCommon.Param.TYPE.getKey()));
        if (type == null && (type = ConcatUriManager.Type.fromMime(uri.getQueryParameter("rewriteMime"))) == null) {
            return BAD_URI;
        }
        String splitParam = type == ConcatUriManager.Type.JS ? uri.getQueryParameter(UriCommon.Param.JSON.getKey()) : null;
        Integer i = (int)START_INDEX;
        String uriStr = null;
        while ((uriStr = uri.getQueryParameter(i.toString())) != null) {
            try {
                uris.add(Uri.parse((String)uriStr));
            }
            catch (IllegalArgumentException e) {
                return BAD_URI;
            }
            Integer e = i;
            Integer n = i = Integer.valueOf(i + 1);
        }
        if (this.versioner != null && (version = uri.getQueryParameter(UriCommon.Param.VERSION.getKey())) != null) {
            status = this.versioner.validate(uris, container, version);
        }
        return new ConcatUriManager.ConcatUri(status, uris, splitParam, type, uri);
    }
}

