/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.auth.AuthInfo;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.FeedProcessor;
import org.apache.shindig.gadgets.FetchResponseUtils;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.servlet.HttpRequestHandler;
import org.apache.shindig.gadgets.servlet.ServletUtil;
import org.apache.shindig.gadgets.uri.UriCommon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class MakeRequestHandler {
    public static final String UNPARSEABLE_CRUFT = "throw 1; < don't be evil' >";
    public static final String POST_DATA_PARAM = "postData";
    public static final String METHOD_PARAM = "httpMethod";
    public static final String HEADERS_PARAM = "headers";
    public static final String CONTENT_TYPE_PARAM = "contentType";
    public static final String NUM_ENTRIES_PARAM = "numEntries";
    public static final String DEFAULT_NUM_ENTRIES = "3";
    public static final String GET_SUMMARIES_PARAM = "getSummaries";
    public static final String GET_FULL_HEADERS_PARAM = "getFullHeaders";
    public static final String AUTHZ_PARAM = "authz";
    private final RequestPipeline requestPipeline;
    private final ResponseRewriterRegistry contentRewriterRegistry;
    private final Provider<FeedProcessor> feedProcessorProvider;

    @Inject
    public MakeRequestHandler(RequestPipeline requestPipeline, ResponseRewriterRegistry contentRewriterRegistry, Provider<FeedProcessor> feedProcessorProvider) {
        this.requestPipeline = requestPipeline;
        this.contentRewriterRegistry = contentRewriterRegistry;
        this.feedProcessorProvider = feedProcessorProvider;
    }

    public void fetch(HttpServletRequest request, HttpServletResponse response) throws GadgetException, IOException {
        HttpRequest rcr = this.buildHttpRequest(request);
        HttpResponse results = this.requestPipeline.execute(rcr);
        if (this.contentRewriterRegistry != null) {
            try {
                results = this.contentRewriterRegistry.rewriteHttpResponse(rcr, results);
            }
            catch (RewritingException e) {
                throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, e, e.getHttpStatusCode());
            }
        }
        String output = this.convertResponseToJson(rcr.getSecurityToken(), request, results);
        MakeRequestHandler.setResponseHeaders(request, response, results);
        response.setStatus(200);
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(UNPARSEABLE_CRUFT + output);
    }

    protected HttpRequest buildHttpRequest(HttpServletRequest request) throws GadgetException {
        String urlStr = request.getParameter(UriCommon.Param.URL.getKey());
        if (urlStr == null) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, UriCommon.Param.URL.getKey() + " parameter is missing.", 400);
        }
        Uri url = null;
        try {
            url = ServletUtil.validateUrl(Uri.parse((String)urlStr));
        }
        catch (IllegalArgumentException e) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Invalid " + UriCommon.Param.URL.getKey() + " parameter", 400);
        }
        HttpRequest req = new HttpRequest(url).setMethod(MakeRequestHandler.getParameter(request, METHOD_PARAM, "GET")).setContainer(MakeRequestHandler.getContainer(request));
        this.setPostData(request, req);
        String headerData = MakeRequestHandler.getParameter(request, HEADERS_PARAM, "");
        if (headerData.length() > 0) {
            String[] headerList;
            for (String header : headerList = StringUtils.split((String)headerData, (char)'&')) {
                String[] parts = StringUtils.splitPreserveAllTokens((String)header, (char)'=');
                if (parts.length != 2) {
                    throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Malformed header param specified:" + header, 400);
                }
                String headerName = Utf8UrlCoder.decode((String)parts[0]);
                if (HttpRequestHandler.BAD_HEADERS.contains(headerName.toUpperCase())) continue;
                req.addHeader(headerName, Utf8UrlCoder.decode((String)parts[1]));
            }
        }
        if ("POST".equals(req.getMethod()) && req.getHeader("Content-Type") == null) {
            req.addHeader("Content-Type", "application/x-www-form-urlencoded");
        }
        req.setIgnoreCache("1".equals(request.getParameter(UriCommon.Param.NO_CACHE.getKey())));
        if (request.getParameter(UriCommon.Param.GADGET.getKey()) != null) {
            req.setGadget(Uri.parse((String)request.getParameter(UriCommon.Param.GADGET.getKey())));
        }
        if (request.getParameter(UriCommon.Param.REFRESH.getKey()) != null) {
            try {
                req.setCacheTtl(Integer.parseInt(request.getParameter(UriCommon.Param.REFRESH.getKey())));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        req.setRewriteMimeType(request.getParameter(UriCommon.Param.REWRITE_MIME_TYPE.getKey()));
        AuthType auth = AuthType.parse(MakeRequestHandler.getParameter(request, AUTHZ_PARAM, null));
        req.setAuthType(auth);
        if (auth != AuthType.NONE) {
            req.setSecurityToken(this.extractAndValidateToken(request));
            req.setOAuthArguments(new OAuthArguments(auth, request));
        }
        ServletUtil.setXForwardedForHeader(request, req);
        return req;
    }

    protected void setPostData(HttpServletRequest request, HttpRequest req) throws GadgetException {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            req.setPostBody(MakeRequestHandler.getParameter(request, POST_DATA_PARAM, "").getBytes(encoding.toUpperCase()));
        }
        catch (UnsupportedEncodingException e) {
            throw new GadgetException(GadgetException.Code.HTML_PARSE_ERROR, e, 400);
        }
    }

    protected String convertResponseToJson(SecurityToken authToken, HttpServletRequest request, HttpResponse results) throws GadgetException {
        String updatedAuthToken;
        boolean getFullHeaders = Boolean.parseBoolean(MakeRequestHandler.getParameter(request, GET_FULL_HEADERS_PARAM, "false"));
        String originalUrl = request.getParameter(UriCommon.Param.URL.getKey());
        String body = results.getResponseAsString();
        if (body.length() > 0 && "FEED".equals(request.getParameter(CONTENT_TYPE_PARAM))) {
            body = this.processFeed(originalUrl, request, body);
        }
        Map<String, Object> resp = FetchResponseUtils.getResponseAsJson(results, null, body, getFullHeaders);
        if (authToken != null && (updatedAuthToken = authToken.getUpdatedToken()) != null) {
            resp.put("st", updatedAuthToken);
        }
        return JsonSerializer.serialize(Collections.singletonMap(originalUrl, resp));
    }

    protected RequestPipeline getRequestPipeline() {
        return this.requestPipeline;
    }

    private SecurityToken extractAndValidateToken(HttpServletRequest request) throws GadgetException {
        SecurityToken token = new AuthInfo(request).getSecurityToken();
        if (token == null) {
            throw new GadgetException(GadgetException.Code.INVALID_SECURITY_TOKEN);
        }
        return token;
    }

    private String processFeed(String url, HttpServletRequest req, String xml) throws GadgetException {
        int numEntries;
        boolean getSummaries = Boolean.parseBoolean(MakeRequestHandler.getParameter(req, GET_SUMMARIES_PARAM, "false"));
        try {
            numEntries = Integer.valueOf(MakeRequestHandler.getParameter(req, NUM_ENTRIES_PARAM, DEFAULT_NUM_ENTRIES));
        }
        catch (NumberFormatException e) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "numEntries paramater is not a number", 400);
        }
        return ((FeedProcessor)this.feedProcessorProvider.get()).process(url, xml, getSummaries, numEntries).toString();
    }

    protected static String getContainer(HttpServletRequest request) {
        String container = request.getParameter(UriCommon.Param.CONTAINER.getKey());
        if (container == null) {
            container = request.getParameter(UriCommon.Param.SYND.getKey());
        }
        return container != null ? container : "default";
    }

    protected static String getParameter(HttpServletRequest request, String key, String defaultValue) {
        String ret = request.getParameter(key);
        return ret != null ? ret : defaultValue;
    }

    protected static void setResponseHeaders(HttpServletRequest request, HttpServletResponse response, HttpResponse results) throws GadgetException {
        int refreshInterval = 0;
        if (results.isStrictNoCache() || "1".equals(request.getParameter(UriCommon.Param.NO_CACHE.getKey()))) {
            refreshInterval = 0;
        } else if (request.getParameter(UriCommon.Param.REFRESH.getKey()) != null) {
            try {
                refreshInterval = Integer.valueOf(request.getParameter(UriCommon.Param.REFRESH.getKey()));
            }
            catch (NumberFormatException nfe) {
                throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "refresh parameter is not a number", 400);
            }
        } else {
            refreshInterval = Math.max(3600, (int)(results.getCacheTtl() / 1000L));
        }
        HttpUtil.setCachingHeaders((HttpServletResponse)response, (int)refreshInterval, (boolean)false);
        response.setHeader("Content-Disposition", "attachment;filename=p.txt");
        if (response.getContentType() == null) {
            response.setContentType("application/octet-stream");
        }
    }
}

