/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.batching;

import com.linkedin.parseq.Context;
import com.linkedin.parseq.Task;
import com.linkedin.parseq.batching.Batch;
import com.linkedin.parseq.batching.BatchingStrategy;
import com.linkedin.parseq.function.Try;
import java.util.Map;
import java.util.Set;

public abstract class TaskBatchingStrategy<G, K, T>
extends BatchingStrategy<G, K, T> {
    @Override
    public final void executeBatch(G group, Batch<K, T> batch) {
        throw new IllegalStateException("This method should be unreachable");
    }

    @Override
    protected void executeBatchWithContext(G group, Batch<K, T> batch, Context ctx) {
        Task<Map<K, Try<T>>> task = this.taskForBatch(group, batch.keys());
        Task completing = task.andThen("completePromises", map -> batch.foreach((key, promise) -> {
            Try result = (Try)map.get(key);
            if (result != null) {
                if (result.isFailed()) {
                    promise.fail(result.getError());
                } else {
                    promise.done(result.get());
                }
            } else {
                promise.fail((Throwable)new Exception("Result for key: " + key + " not found in batch response"));
            }
        }));
        completing.getShallowTraceBuilder().setSystemHidden(true);
        Task withFailureHandling = completing.onFailure("handleFailures", t -> batch.failAll((Throwable)t));
        withFailureHandling.getShallowTraceBuilder().setSystemHidden(true);
        ctx.run(new Task[]{withFailureHandling});
    }

    @Override
    public final String getBatchName(G group, Batch<K, T> batch) {
        return this.getBatchName(group, batch.keys());
    }

    public String getBatchName(G group, Set<K> keys) {
        return "batch(" + keys.size() + ")";
    }

    public abstract Task<Map<K, Try<T>>> taskForBatch(G var1, Set<K> var2);
}

