/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.batching;

import java.util.function.Function;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchSizeMetric {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchSizeMetric.class);
    private static final int LOWEST_DISCERNIBLE_VALUE = 1;
    private static final int HIGHEST_TRACKABLE_VALUE = 10000;
    private static final int NUMBER_OF_FIGNIFICANT_VALUE_DIGITS = 3;
    private Recorder _recorder = null;
    private Histogram _recycle;

    public void record(int batchSize) {
        this.recordSafeValue(this.narrow(batchSize));
    }

    private int narrow(int batchSize) {
        if (batchSize < 1) {
            LOGGER.warn("batch size lower than expected: {}, recording as: ", (Object)batchSize, (Object)1);
            return 1;
        }
        if (batchSize > 10000) {
            LOGGER.warn("batch size greater than expected: {}, recording as: ", (Object)batchSize, (Object)10000);
            return 10000;
        }
        return batchSize;
    }

    private void initializeRecorder() {
        if (this._recorder == null) {
            this._recorder = new Recorder(1L, 10000L, 3);
        }
    }

    private synchronized void recordSafeValue(int batchSize) {
        this.initializeRecorder();
        this._recorder.recordValue((long)batchSize);
    }

    public synchronized <T> T harvest(Function<Histogram, T> consumer) {
        this.initializeRecorder();
        this._recycle = this._recorder.getIntervalHistogram(this._recycle);
        return consumer.apply(this._recycle);
    }
}

