/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.batching;

import com.linkedin.parseq.batching.Batch;
import com.linkedin.parseq.batching.BatchAggregationTimeMetric;
import com.linkedin.parseq.internal.ArgumentUtil;
import com.linkedin.parseq.promise.PromiseException;
import com.linkedin.parseq.promise.PromiseListener;
import com.linkedin.parseq.promise.PromiseResolvedException;
import com.linkedin.parseq.promise.PromiseUnresolvedException;
import com.linkedin.parseq.promise.Promises;
import com.linkedin.parseq.promise.SettablePromise;
import com.linkedin.parseq.trace.ShallowTraceBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public class BatchImpl<K, T>
implements Batch<K, T> {
    private final Map<K, BatchEntry<T>> _map;
    private final int _batchSize;

    private BatchImpl(Map<K, BatchEntry<T>> map, int batchSize) {
        this._map = map;
        this._batchSize = batchSize;
    }

    @Override
    public void done(K key, T value) throws PromiseResolvedException {
        this._map.get(key).getPromise().done(value);
    }

    @Override
    public void fail(K key, Throwable error) throws PromiseResolvedException {
        this._map.get(key).getPromise().fail(error);
    }

    @Override
    public int failAll(Throwable error) {
        int alreadyResolved = 0;
        for (Map.Entry<K, BatchEntry<T>> entry : this._map.entrySet()) {
            try {
                entry.getValue().getPromise().fail(error);
            }
            catch (PromiseResolvedException e) {
                ++alreadyResolved;
            }
        }
        return alreadyResolved;
    }

    @Override
    public Set<K> keys() {
        return this._map.keySet();
    }

    @Override
    public void foreach(BiConsumer<K, SettablePromise<T>> consumer) {
        this._map.forEach((key, entry) -> consumer.accept(key, entry.getPromise()));
    }

    public String toString() {
        return "BatchImpl [entries=" + this._map + "]";
    }

    @Override
    public Collection<BatchEntry<T>> values() {
        return this._map.values();
    }

    @Override
    public Set<Map.Entry<K, BatchEntry<T>>> entries() {
        return this._map.entrySet();
    }

    @Override
    public int keySize() {
        return this._map.size();
    }

    @Override
    public int batchSize() {
        return this._batchSize;
    }

    static class BatchBuilder<K, T> {
        private final Map<K, BatchEntry<T>> _map = new HashMap<K, BatchEntry<T>>();
        private Batch<K, T> _batch = null;
        private final int _maxSize;
        private final BatchAggregationTimeMetric _batchAggregationTimeMetric;
        private int _batchSize = 0;

        public BatchBuilder(int maxSize, BatchAggregationTimeMetric batchAggregationTimeMetric) {
            ArgumentUtil.requirePositive((int)maxSize, (String)"max batch size");
            this._maxSize = maxSize;
            this._batchAggregationTimeMetric = batchAggregationTimeMetric;
        }

        private static final boolean safeToAddWithoutOverflow(int left, int right) {
            return !(right > 0 ? left > Integer.MAX_VALUE - right : left < Integer.MIN_VALUE - right);
        }

        boolean add(K key, BatchEntry<T> entry, int size) {
            if (this._batch != null) {
                throw new IllegalStateException("BatchBuilder has already been used to build a batch");
            }
            if (this._batchSize == 0 || BatchBuilder.safeToAddWithoutOverflow(this._batchSize, size) && this._batchSize + size <= this._maxSize) {
                BatchEntry<T> duplicate = this._map.get(key);
                if (duplicate != null) {
                    Promises.propagateResult(duplicate.getPromise().getInternal(), entry.getPromise());
                    duplicate.getPromise().addListener(p -> entry.getPromise().trigger());
                    duplicate.addShallowTraceBuilders(entry.getShallowTraceBuilders());
                } else {
                    this._map.put(key, entry);
                }
                this._batchSize += size;
                return true;
            }
            return false;
        }

        boolean add(K key, ShallowTraceBuilder traceBuilder, BatchPromise<T> promise, int size) {
            return this.add(key, new BatchEntry<T>(traceBuilder, promise), size);
        }

        public boolean isFull() {
            return this._batchSize >= this._maxSize;
        }

        public Batch<K, T> build() {
            if (this._batch == null) {
                long _currentTimeNano = System.nanoTime();
                this._map.values().forEach(entry -> {
                    long time = _currentTimeNano - ((BatchEntry)entry)._creationTimeNano;
                    this._batchAggregationTimeMetric.record(time > 0L ? time : 0L);
                });
                this._batch = new BatchImpl(this._map, this._batchSize);
            }
            return this._batch;
        }

        public int size() {
            return this._map.size();
        }

        public int batchSize() {
            return this._batchSize;
        }
    }

    public static class BatchEntry<T> {
        private final BatchPromise<T> _promise;
        private final List<ShallowTraceBuilder> _shallowTraceBuilders = new ArrayList<ShallowTraceBuilder>();
        private final long _creationTimeNano = System.nanoTime();

        public BatchEntry(ShallowTraceBuilder shallowTraceBuilder, BatchPromise<T> promise) {
            this._promise = promise;
            this._shallowTraceBuilders.add(shallowTraceBuilder);
        }

        public BatchPromise<T> getPromise() {
            return this._promise;
        }

        List<ShallowTraceBuilder> getShallowTraceBuilders() {
            return this._shallowTraceBuilders;
        }

        void addShallowTraceBuilder(ShallowTraceBuilder shallowTraceBuilder) {
            this._shallowTraceBuilders.add(shallowTraceBuilder);
        }

        void addShallowTraceBuilders(List<ShallowTraceBuilder> shallowTraceBuilders) {
            this._shallowTraceBuilders.addAll(shallowTraceBuilders);
        }
    }

    public static class BatchPromise<T>
    implements SettablePromise<T> {
        private final SettablePromise<T> _internal = Promises.settable();
        private final SettablePromise<T> _external = Promises.settable();

        public T get() throws PromiseException {
            return (T)this._internal.get();
        }

        public Throwable getError() throws PromiseUnresolvedException {
            return this._internal.getError();
        }

        public T getOrDefault(T defaultValue) throws PromiseUnresolvedException {
            return (T)this._internal.getOrDefault(defaultValue);
        }

        public void await() throws InterruptedException {
            this._internal.await();
        }

        public boolean await(long time, TimeUnit unit) throws InterruptedException {
            return this._internal.await(time, unit);
        }

        public void addListener(PromiseListener<T> listener) {
            this._external.addListener(listener);
        }

        public boolean isDone() {
            return this._internal.isDone();
        }

        public boolean isFailed() {
            return this._internal.isFailed();
        }

        public void done(T value) throws PromiseResolvedException {
            this._internal.done(value);
        }

        public void fail(Throwable error) throws PromiseResolvedException {
            this._internal.fail(error);
        }

        public void trigger() {
            Promises.propagateResult(this._internal, this._external);
        }

        public SettablePromise<T> getInternal() {
            return this._internal;
        }
    }
}

