/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.batching;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchAggregationTimeMetric {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchAggregationTimeMetric.class);
    private static final long LOWEST_DISCERNIBLE_VALUE = 1L;
    private static final long HIGHEST_TRACKABLE_VALUE = TimeUnit.HOURS.toNanos(1L);
    private static final int NUMBER_OF_FIGNIFICANT_VALUE_DIGITS = 3;
    private Recorder _recorder = null;
    private Histogram _recycle;

    public void record(long batchAggregationTimeNano) {
        this.recordSafeValue(this.narrow(batchAggregationTimeNano));
    }

    private long narrow(long batchAggregationTimeNano) {
        if (batchAggregationTimeNano < 1L) {
            LOGGER.warn("batch aggregation time lower than expected: {}, recording as: {}", (Object)batchAggregationTimeNano, (Object)1L);
            return 1L;
        }
        if (batchAggregationTimeNano > HIGHEST_TRACKABLE_VALUE) {
            LOGGER.warn("batch aggregation time greater than expected: {}, recording as: {}", (Object)batchAggregationTimeNano, (Object)HIGHEST_TRACKABLE_VALUE);
            return HIGHEST_TRACKABLE_VALUE;
        }
        return batchAggregationTimeNano;
    }

    private void initializeRecorder() {
        if (this._recorder == null) {
            this._recorder = new Recorder(1L, HIGHEST_TRACKABLE_VALUE, 3);
        }
    }

    private synchronized void recordSafeValue(long batchAggregationTimeNano) {
        this.initializeRecorder();
        this._recorder.recordValue(batchAggregationTimeNano);
    }

    public synchronized <T> T harvest(Function<Histogram, T> consumer) {
        this.initializeRecorder();
        this._recycle = this._recorder.getIntervalHistogram(this._recycle);
        return consumer.apply(this._recycle);
    }
}

