/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.jbig2.segments;

import com.levigo.jbig2.Bitmap;
import com.levigo.jbig2.Region;
import com.levigo.jbig2.SegmentHeader;
import com.levigo.jbig2.decoder.arithmetic.ArithmeticDecoder;
import com.levigo.jbig2.decoder.arithmetic.CX;
import com.levigo.jbig2.err.IntegerMaxValueException;
import com.levigo.jbig2.err.InvalidHeaderValueException;
import com.levigo.jbig2.io.SubInputStream;
import com.levigo.jbig2.segments.RegionSegmentInformation;
import com.levigo.jbig2.util.log.Logger;
import com.levigo.jbig2.util.log.LoggerFactory;
import java.io.IOException;

public class GenericRefinementRegion
implements Region {
    private static final Logger log = LoggerFactory.getLogger(GenericRefinementRegion.class);
    private static final Template T0 = new Template0();
    private static final Template T1 = new Template1();
    private SubInputStream subInputStream;
    private SegmentHeader segmentHeader;
    private RegionSegmentInformation regionInfo;
    private boolean isTPGROn;
    private short templateID;
    private Template template;
    private short[] grAtX;
    private short[] grAtY;
    private Bitmap regionBitmap;
    private Bitmap referenceBitmap;
    private int referenceDX;
    private int referenceDY;
    private ArithmeticDecoder arithDecoder;
    private CX cx;
    private boolean override;
    private boolean[] grAtOverride;

    public GenericRefinementRegion() {
    }

    public GenericRefinementRegion(SubInputStream subInputStream) {
        this.subInputStream = subInputStream;
        this.regionInfo = new RegionSegmentInformation(subInputStream);
    }

    public GenericRefinementRegion(SubInputStream subInputStream, SegmentHeader segmentHeader) {
        this.subInputStream = subInputStream;
        this.segmentHeader = segmentHeader;
        this.regionInfo = new RegionSegmentInformation(subInputStream);
    }

    private void parseHeader() throws IOException {
        this.regionInfo.parseHeader();
        this.subInputStream.readBits(6);
        if (this.subInputStream.readBit() == 1) {
            this.isTPGROn = true;
        }
        this.templateID = (short)this.subInputStream.readBit();
        switch (this.templateID) {
            case 0: {
                this.template = T0;
                this.readAtPixels();
                break;
            }
            case 1: {
                this.template = T1;
            }
        }
    }

    private void readAtPixels() throws IOException {
        this.grAtX = new short[2];
        this.grAtY = new short[2];
        this.grAtX[0] = this.subInputStream.readByte();
        this.grAtY[0] = this.subInputStream.readByte();
        this.grAtX[1] = this.subInputStream.readByte();
        this.grAtY[1] = this.subInputStream.readByte();
    }

    @Override
    public Bitmap getRegionBitmap() throws IOException, IntegerMaxValueException, InvalidHeaderValueException {
        if (null == this.regionBitmap) {
            int n = 0;
            if (this.referenceBitmap == null) {
                this.referenceBitmap = this.getGrReference();
            }
            if (this.arithDecoder == null) {
                this.arithDecoder = new ArithmeticDecoder(this.subInputStream);
            }
            if (this.cx == null) {
                this.cx = new CX(8192, 1);
            }
            this.regionBitmap = new Bitmap(this.regionInfo.getBitmapWidth(), this.regionInfo.getBitmapHeight());
            if (this.templateID == 0) {
                this.updateOverride();
            }
            int n2 = this.regionBitmap.getWidth() + 7 & 0xFFFFFFF8;
            int n3 = this.isTPGROn ? -this.referenceDY * this.referenceBitmap.getRowStride() : 0;
            int n4 = n3 + 1;
            for (int i = 0; i < this.regionBitmap.getHeight(); ++i) {
                if (this.isTPGROn) {
                    n ^= this.decodeSLTP();
                }
                if (n == 0) {
                    this.decodeOptimized(i, this.regionBitmap.getWidth(), this.regionBitmap.getRowStride(), this.referenceBitmap.getRowStride(), n2, n3, n4);
                    continue;
                }
                this.decodeTypicalPredictedLine(i, this.regionBitmap.getWidth(), this.regionBitmap.getRowStride(), this.referenceBitmap.getRowStride(), n2, n3);
            }
        }
        return this.regionBitmap;
    }

    private int decodeSLTP() throws IOException {
        this.template.setIndex(this.cx);
        return this.arithDecoder.decode(this.cx);
    }

    private Bitmap getGrReference() throws IntegerMaxValueException, InvalidHeaderValueException, IOException {
        SegmentHeader[] segmentHeaderArray = this.segmentHeader.getRtSegments();
        Region region = (Region)segmentHeaderArray[0].getSegmentData();
        return region.getRegionBitmap();
    }

    private void decodeOptimized(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IOException {
        int n8 = n - this.referenceDY;
        int n9 = this.referenceBitmap.getByteIndex(Math.max(0, -this.referenceDX), n8);
        int n10 = this.regionBitmap.getByteIndex(Math.max(0, this.referenceDX), n);
        switch (this.templateID) {
            case 0: {
                this.decodeTemplate(n, n2, n3, n4, n5, n6, n7, n10, n8, n9, T0);
                break;
            }
            case 1: {
                this.decodeTemplate(n, n2, n3, n4, n5, n6, n7, n10, n8, n9, T1);
            }
        }
    }

    private void decodeTemplate(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Template template) throws IOException {
        short s;
        short s2;
        short s3;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        if (n9 >= 1 && n9 - 1 < this.referenceBitmap.getHeight()) {
            n14 = this.referenceBitmap.getByteAsInteger(n10 - n4);
        }
        if (n9 >= 0 && n9 < this.referenceBitmap.getHeight()) {
            n13 = this.referenceBitmap.getByteAsInteger(n10);
        }
        if (n9 >= -1 && n9 + 1 < this.referenceBitmap.getHeight()) {
            n12 = this.referenceBitmap.getByteAsInteger(n10 + n4);
        }
        ++n10;
        if (n >= 1) {
            n11 = this.regionBitmap.getByteAsInteger(n8 - n3);
        }
        ++n8;
        int n15 = this.referenceDX % 8;
        int n16 = 6 + n15;
        int n17 = n10 % n4;
        if (n16 >= 0) {
            s3 = (short)((n16 >= 8 ? 0 : n14 >>> n16) & 7);
            s2 = (short)((n16 >= 8 ? 0 : n13 >>> n16) & 7);
            s = (short)((n16 >= 8 ? 0 : n12 >>> n16) & 7);
            if (n16 == 6 && n17 > 1) {
                if (n9 >= 1 && n9 - 1 < this.referenceBitmap.getHeight()) {
                    s3 = (short)(s3 | this.referenceBitmap.getByteAsInteger(n10 - n4 - 2) << 2 & 4);
                }
                if (n9 >= 0 && n9 < this.referenceBitmap.getHeight()) {
                    s2 = (short)(s2 | this.referenceBitmap.getByteAsInteger(n10 - 2) << 2 & 4);
                }
                if (n9 >= -1 && n9 + 1 < this.referenceBitmap.getHeight()) {
                    s = (short)(s | this.referenceBitmap.getByteAsInteger(n10 + n4 - 2) << 2 & 4);
                }
            }
            if (n16 == 0) {
                n12 = 0;
                n13 = 0;
                n14 = 0;
                if (n17 < n4 - 1) {
                    if (n9 >= 1 && n9 - 1 < this.referenceBitmap.getHeight()) {
                        n14 = this.referenceBitmap.getByteAsInteger(n10 - n4);
                    }
                    if (n9 >= 0 && n9 < this.referenceBitmap.getHeight()) {
                        n13 = this.referenceBitmap.getByteAsInteger(n10);
                    }
                    if (n9 >= -1 && n9 + 1 < this.referenceBitmap.getHeight()) {
                        n12 = this.referenceBitmap.getByteAsInteger(n10 + n4);
                    }
                }
                ++n10;
            }
        } else {
            s3 = (short)(n14 << 1 & 7);
            s2 = (short)(n13 << 1 & 7);
            s = (short)(n12 << 1 & 7);
            n12 = 0;
            n13 = 0;
            n14 = 0;
            if (n17 < n4 - 1) {
                if (n9 >= 1 && n9 - 1 < this.referenceBitmap.getHeight()) {
                    n14 = this.referenceBitmap.getByteAsInteger(n10 - n4);
                }
                if (n9 >= 0 && n9 < this.referenceBitmap.getHeight()) {
                    n13 = this.referenceBitmap.getByteAsInteger(n10);
                }
                if (n9 >= -1 && n9 + 1 < this.referenceBitmap.getHeight()) {
                    n12 = this.referenceBitmap.getByteAsInteger(n10 + n4);
                }
                ++n10;
            }
            s3 = (short)(s3 | (short)(n14 >>> 7 & 7));
            s2 = (short)(s2 | (short)(n13 >>> 7 & 7));
            s = (short)(s | (short)(n12 >>> 7 & 7));
        }
        short s4 = (short)(n11 >>> 6);
        short s5 = 0;
        int n18 = (2 - n15) % 8;
        n14 <<= n18;
        n13 <<= n18;
        n12 <<= n18;
        n11 <<= 2;
        for (int i = 0; i < n2; ++i) {
            int n19 = i & 7;
            short s6 = template.form(s3, s2, s, s4, s5);
            if (this.override) {
                this.cx.setIndex(this.overrideAtTemplate0(s6, i, n, this.regionBitmap.getByte(this.regionBitmap.getByteIndex(i, n)), n19));
            } else {
                this.cx.setIndex(s6);
            }
            int n20 = this.arithDecoder.decode(this.cx);
            this.regionBitmap.setPixel(i, n, (byte)n20);
            s3 = (short)((s3 << 1 | 1 & n14 >>> 7) & 7);
            s2 = (short)((s2 << 1 | 1 & n13 >>> 7) & 7);
            s = (short)((s << 1 | 1 & n12 >>> 7) & 7);
            s4 = (short)((s4 << 1 | 1 & n11 >>> 7) & 7);
            s5 = (short)n20;
            if ((i - this.referenceDX) % 8 == 5) {
                if ((i - this.referenceDX) / 8 + 1 >= this.referenceBitmap.getRowStride()) {
                    n12 = 0;
                    n13 = 0;
                    n14 = 0;
                } else {
                    n14 = n9 >= 1 && n9 - 1 < this.referenceBitmap.getHeight() ? this.referenceBitmap.getByteAsInteger(n10 - n4) : 0;
                    n13 = n9 >= 0 && n9 < this.referenceBitmap.getHeight() ? this.referenceBitmap.getByteAsInteger(n10) : 0;
                    n12 = n9 >= -1 && n9 + 1 < this.referenceBitmap.getHeight() ? this.referenceBitmap.getByteAsInteger(n10 + n4) : 0;
                }
                ++n10;
            } else {
                n14 <<= 1;
                n13 <<= 1;
                n12 <<= 1;
            }
            if (n19 == 5 && n >= 1) {
                n11 = (i >> 3) + 1 >= this.regionBitmap.getRowStride() ? 0 : this.regionBitmap.getByteAsInteger(n8 - n3);
                ++n8;
                continue;
            }
            n11 <<= 1;
        }
    }

    private void updateOverride() {
        if (this.grAtX == null || this.grAtY == null) {
            log.info("AT pixels not set");
            return;
        }
        if (this.grAtX.length != this.grAtY.length) {
            log.info("AT pixel inconsistent");
            return;
        }
        this.grAtOverride = new boolean[this.grAtX.length];
        switch (this.templateID) {
            case 0: {
                if (this.grAtX[0] != -1 && this.grAtY[0] != -1) {
                    this.grAtOverride[0] = true;
                    this.override = true;
                }
                if (this.grAtX[1] == -1 || this.grAtY[1] == -1) break;
                this.grAtOverride[1] = true;
                this.override = true;
                break;
            }
            case 1: {
                this.override = false;
            }
        }
    }

    private void decodeTypicalPredictedLine(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        int n7 = n - this.referenceDY;
        int n8 = this.referenceBitmap.getByteIndex(0, n7);
        int n9 = this.regionBitmap.getByteIndex(0, n);
        switch (this.templateID) {
            case 0: {
                this.decodeTypicalPredictedLineTemplate0(n, n2, n3, n4, n5, n6, n9, n7, n8);
                break;
            }
            case 1: {
                this.decodeTypicalPredictedLineTemplate1(n, n2, n3, n4, n5, n6, n9, n7, n8);
            }
        }
    }

    private void decodeTypicalPredictedLineTemplate0(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) throws IOException {
        int n10 = n > 0 ? this.regionBitmap.getByteAsInteger(n7 - n3) : 0;
        int n11 = n8 > 0 && n8 <= this.referenceBitmap.getHeight() ? this.referenceBitmap.getByteAsInteger(n9 - n4 + n6) << 4 : 0;
        int n12 = n8 >= 0 && n8 < this.referenceBitmap.getHeight() ? this.referenceBitmap.getByteAsInteger(n9 + n6) << 1 : 0;
        int n13 = n8 > -2 && n8 < this.referenceBitmap.getHeight() - 1 ? this.referenceBitmap.getByteAsInteger(n9 + n4 + n6) : 0;
        int n14 = n10 >> 5 & 6 | n13 >> 2 & 0x30 | n12 & 0x180 | n11 & 0xC00;
        int n15 = 0;
        while (n15 < n5) {
            byte by = 0;
            int n16 = n15 + 8;
            int n17 = n2 - n15 > 8 ? 8 : n2 - n15;
            boolean bl = n16 < n2;
            boolean bl2 = n16 < this.referenceBitmap.getWidth();
            int n18 = n6 + 1;
            if (n > 0) {
                n10 = n10 << 8 | (bl ? this.regionBitmap.getByteAsInteger(n7 - n3 + 1) : 0);
            }
            if (n8 > 0 && n8 <= this.referenceBitmap.getHeight()) {
                n11 = n11 << 8 | (bl2 ? this.referenceBitmap.getByteAsInteger(n9 - n4 + n18) << 4 : 0);
            }
            if (n8 >= 0 && n8 < this.referenceBitmap.getHeight()) {
                n12 = n12 << 8 | (bl2 ? this.referenceBitmap.getByteAsInteger(n9 + n18) << 1 : 0);
            }
            if (n8 > -2 && n8 < this.referenceBitmap.getHeight() - 1) {
                n13 = n13 << 8 | (bl2 ? this.referenceBitmap.getByteAsInteger(n9 + n4 + n18) : 0);
            }
            for (int i = 0; i < n17; ++i) {
                boolean bl3 = false;
                int n19 = 0;
                int n20 = n14 >> 4 & 0x1FF;
                if (n20 == 511) {
                    bl3 = true;
                    n19 = 1;
                } else if (n20 == 0) {
                    bl3 = true;
                    n19 = 0;
                }
                if (!bl3) {
                    if (this.override) {
                        int n21 = this.overrideAtTemplate0(n14, n15 + i, n, by, i);
                        this.cx.setIndex(n21);
                    } else {
                        this.cx.setIndex(n14);
                    }
                    n19 = this.arithDecoder.decode(this.cx);
                }
                int n22 = 7 - i;
                by = (byte)(by | n19 << n22);
                n14 = (n14 & 0xDB6) << 1 | n19 | n10 >> n22 + 5 & 2 | n13 >> n22 + 2 & 0x10 | n12 >> n22 & 0x80 | n11 >> n22 & 0x400;
            }
            this.regionBitmap.setByte(n7++, by);
            ++n9;
            n15 = n16;
        }
    }

    private void decodeTypicalPredictedLineTemplate1(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) throws IOException {
        int n10 = n > 0 ? this.regionBitmap.getByteAsInteger(n7 - n3) : 0;
        int n11 = n8 > 0 && n8 <= this.referenceBitmap.getHeight() ? this.referenceBitmap.getByteAsInteger(n7 - n4 + n6) << 2 : 0;
        int n12 = n8 >= 0 && n8 < this.referenceBitmap.getHeight() ? this.referenceBitmap.getByteAsInteger(n7 + n6) : 0;
        int n13 = n8 > -2 && n8 < this.referenceBitmap.getHeight() - 1 ? this.referenceBitmap.getByteAsInteger(n7 + n4 + n6) : 0;
        int n14 = n10 >> 5 & 6 | n13 >> 2 & 0x30 | n12 & 0xC0 | n11 & 0x200;
        int n15 = n13 >> 2 & 0x70 | n12 & 0xC0 | n11 & 0x700;
        int n16 = 0;
        while (n16 < n5) {
            byte by = 0;
            int n17 = n16 + 8;
            int n18 = n2 - n16 > 8 ? 8 : n2 - n16;
            boolean bl = n17 < n2;
            boolean bl2 = n17 < this.referenceBitmap.getWidth();
            int n19 = n6 + 1;
            if (n > 0) {
                n10 = n10 << 8 | (bl ? this.regionBitmap.getByteAsInteger(n7 - n3 + 1) : 0);
            }
            if (n8 > 0 && n8 <= this.referenceBitmap.getHeight()) {
                n11 = n11 << 8 | (bl2 ? this.referenceBitmap.getByteAsInteger(n9 - n4 + n19) << 2 : 0);
            }
            if (n8 >= 0 && n8 < this.referenceBitmap.getHeight()) {
                n12 = n12 << 8 | (bl2 ? this.referenceBitmap.getByteAsInteger(n9 + n19) : 0);
            }
            if (n8 > -2 && n8 < this.referenceBitmap.getHeight() - 1) {
                n13 = n13 << 8 | (bl2 ? this.referenceBitmap.getByteAsInteger(n9 + n4 + n19) : 0);
            }
            for (int i = 0; i < n18; ++i) {
                int n20 = 0;
                int n21 = n15 >> 4 & 0x1FF;
                if (n21 == 511) {
                    n20 = 1;
                } else if (n21 == 0) {
                    n20 = 0;
                } else {
                    this.cx.setIndex(n14);
                    n20 = this.arithDecoder.decode(this.cx);
                }
                int n22 = 7 - i;
                by = (byte)(by | n20 << n22);
                n14 = (n14 & 0xD6) << 1 | n20 | n10 >> n22 + 5 & 2 | n13 >> n22 + 2 & 0x10 | n12 >> n22 & 0x40 | n11 >> n22 & 0x200;
                n15 = (n15 & 0xDB) << 1 | n13 >> n22 + 2 & 0x10 | n12 >> n22 & 0x80 | n11 >> n22 & 0x400;
            }
            this.regionBitmap.setByte(n7++, by);
            ++n9;
            n16 = n17;
        }
    }

    private int overrideAtTemplate0(int n, int n2, int n3, int n4, int n5) throws IOException {
        if (this.grAtOverride[0]) {
            n &= 0xFFF7;
            n = this.grAtY[0] == 0 && this.grAtX[0] >= -n5 ? (n |= (n4 >> 7 - (n5 + this.grAtX[0]) & 1) << 3) : (n |= this.getPixel(this.regionBitmap, n2 + this.grAtX[0], n3 + this.grAtY[0]) << 3);
        }
        if (this.grAtOverride[1]) {
            n &= 0xEFFF;
            n = this.grAtY[1] == 0 && this.grAtX[1] >= -n5 ? (n |= (n4 >> 7 - (n5 + this.grAtX[1]) & 1) << 12) : (n |= this.getPixel(this.referenceBitmap, n2 + this.grAtX[1] + this.referenceDX, n3 + this.grAtY[1] + this.referenceDY) << 12);
        }
        return n;
    }

    private byte getPixel(Bitmap bitmap, int n, int n2) throws IOException {
        if (n < 0 || n >= bitmap.getWidth()) {
            return 0;
        }
        if (n2 < 0 || n2 >= bitmap.getHeight()) {
            return 0;
        }
        return bitmap.getPixel(n, n2);
    }

    @Override
    public void init(SegmentHeader segmentHeader, SubInputStream subInputStream) throws IOException {
        this.segmentHeader = segmentHeader;
        this.subInputStream = subInputStream;
        this.regionInfo = new RegionSegmentInformation(this.subInputStream);
        this.parseHeader();
    }

    protected void setParameters(CX cX, ArithmeticDecoder arithmeticDecoder, short s, int n, int n2, Bitmap bitmap, int n3, int n4, boolean bl, short[] sArray, short[] sArray2) {
        if (null != cX) {
            this.cx = cX;
        }
        if (null != arithmeticDecoder) {
            this.arithDecoder = arithmeticDecoder;
        }
        this.templateID = s;
        this.regionInfo.setBitmapWidth(n);
        this.regionInfo.setBitmapHeight(n2);
        this.referenceBitmap = bitmap;
        this.referenceDX = n3;
        this.referenceDY = n4;
        this.isTPGROn = bl;
        this.grAtX = sArray;
        this.grAtY = sArray2;
        this.regionBitmap = null;
    }

    @Override
    public RegionSegmentInformation getRegionInfo() {
        return this.regionInfo;
    }

    private static class Template1
    extends Template {
        private Template1() {
        }

        @Override
        protected short form(short s, short s2, short s3, short s4, short s5) {
            return (short)((s & 2) << 8 | s2 << 6 | (s3 & 3) << 4 | s4 << 1 | s5);
        }

        @Override
        protected void setIndex(CX cX) {
            cX.setIndex(128);
        }
    }

    private static class Template0
    extends Template {
        private Template0() {
        }

        @Override
        protected short form(short s, short s2, short s3, short s4, short s5) {
            return (short)(s << 10 | s2 << 7 | s3 << 4 | s4 << 1 | s5);
        }

        @Override
        protected void setIndex(CX cX) {
            cX.setIndex(256);
        }
    }

    public static abstract class Template {
        protected abstract short form(short var1, short var2, short var3, short var4, short var5);

        protected abstract void setIndex(CX var1);
    }
}

