/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.files;

import com.launchdarkly.client.files.DataLoaderException;
import com.launchdarkly.client.files.FlagFileRep;
import com.launchdarkly.client.files.JsonFlagFileParser;
import com.launchdarkly.client.files.YamlFlagFileParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

abstract class FlagFileParser {
    private static final FlagFileParser jsonParser = new JsonFlagFileParser();
    private static final FlagFileParser yamlParser = new YamlFlagFileParser();

    FlagFileParser() {
    }

    public abstract FlagFileRep parse(InputStream var1) throws DataLoaderException, IOException;

    public static FlagFileParser selectForContent(byte[] data) {
        InputStreamReader r = new InputStreamReader(new ByteArrayInputStream(data));
        return FlagFileParser.detectJson(r) ? jsonParser : yamlParser;
    }

    private static boolean detectJson(Reader r) {
        try {
            int ch;
            do {
                if ((ch = r.read()) < 0) {
                    return false;
                }
                if (ch != 123) continue;
                return true;
            } while (Character.isWhitespace(ch));
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

