/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.FeatureFlag;
import com.launchdarkly.client.FeatureFlagBuilder;
import com.launchdarkly.client.Prerequisite;
import com.launchdarkly.client.Segment;
import com.launchdarkly.client.VersionedData;
import com.launchdarkly.shaded.com.google.common.base.Function;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import com.launchdarkly.shaded.com.google.common.collect.Iterables;

public abstract class VersionedDataKind<T extends VersionedData> {
    public static VersionedDataKind<FeatureFlag> FEATURES = new Impl<FeatureFlag>("features", FeatureFlag.class, "/flags/", 1){

        @Override
        public FeatureFlag makeDeletedItem(String key, int version) {
            return new FeatureFlagBuilder(key).deleted(true).version(version).build();
        }

        @Override
        public boolean isDependencyOrdered() {
            return true;
        }

        @Override
        public Iterable<String> getDependencyKeys(VersionedData item) {
            FeatureFlag flag = (FeatureFlag)item;
            if (flag.getPrerequisites() == null || flag.getPrerequisites().isEmpty()) {
                return ImmutableList.of();
            }
            return Iterables.transform(flag.getPrerequisites(), new Function<Prerequisite, String>(){

                @Override
                public String apply(Prerequisite p) {
                    return p.getKey();
                }
            });
        }
    };
    public static VersionedDataKind<Segment> SEGMENTS = new Impl<Segment>("segments", Segment.class, "/segments/", 0){

        @Override
        public Segment makeDeletedItem(String key, int version) {
            return new Segment.Builder(key).deleted(true).version(version).build();
        }
    };
    public static Iterable<VersionedDataKind<?>> ALL = ImmutableList.of(FEATURES, SEGMENTS);

    public abstract String getNamespace();

    public abstract Class<T> getItemClass();

    public abstract String getStreamApiPath();

    public abstract T makeDeletedItem(String var1, int var2);

    public int getPriority() {
        return this.getNamespace().length() + 10;
    }

    public boolean isDependencyOrdered() {
        return false;
    }

    public Iterable<String> getDependencyKeys(VersionedData item) {
        return ImmutableList.of();
    }

    public String toString() {
        return "{" + this.getNamespace() + "}";
    }

    String getKeyFromStreamApiPath(String path) {
        return path.startsWith(this.getStreamApiPath()) ? path.substring(this.getStreamApiPath().length()) : null;
    }

    static abstract class Impl<T extends VersionedData>
    extends VersionedDataKind<T> {
        private final String namespace;
        private final Class<T> itemClass;
        private final String streamApiPath;
        private final int priority;

        Impl(String namespace, Class<T> itemClass, String streamApiPath, int priority) {
            this.namespace = namespace;
            this.itemClass = itemClass;
            this.streamApiPath = streamApiPath;
            this.priority = priority;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public Class<T> getItemClass() {
            return this.itemClass;
        }

        @Override
        public String getStreamApiPath() {
            return this.streamApiPath;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }
    }
}

