/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.launchdarkly.client.FeatureFlag;
import com.launchdarkly.client.FeatureRequestor;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.LDClient;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.Segment;
import com.launchdarkly.client.UpdateProcessor;
import com.launchdarkly.client.Util;
import com.launchdarkly.client.VersionedData;
import com.launchdarkly.client.VersionedDataKind;
import com.launchdarkly.shaded.com.google.common.util.concurrent.SettableFuture;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.ConnectionErrorHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.EventSource;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.MessageEvent;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.UnsuccessfulResponseException;
import com.launchdarkly.shaded.okhttp3.Headers;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StreamProcessor
implements UpdateProcessor {
    private static final String PUT = "put";
    private static final String PATCH = "patch";
    private static final String DELETE = "delete";
    private static final String INDIRECT_PUT = "indirect/put";
    private static final String INDIRECT_PATCH = "indirect/patch";
    private static final Logger logger = LoggerFactory.getLogger(StreamProcessor.class);
    private static final int DEAD_CONNECTION_INTERVAL_MS = 300000;
    private final FeatureStore store;
    private final LDConfig config;
    private final String sdkKey;
    private final FeatureRequestor requestor;
    private final EventSourceCreator eventSourceCreator;
    private volatile EventSource es;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    StreamProcessor(String sdkKey, LDConfig config, FeatureRequestor requestor, FeatureStore featureStore, EventSourceCreator eventSourceCreator) {
        this.store = featureStore;
        this.config = config;
        this.sdkKey = sdkKey;
        this.requestor = requestor;
        this.eventSourceCreator = eventSourceCreator != null ? eventSourceCreator : new DefaultEventSourceCreator();
    }

    @Override
    public Future<Void> start() {
        final SettableFuture<Void> initFuture = SettableFuture.create();
        Headers headers = new Headers.Builder().add("Authorization", this.sdkKey).add("User-Agent", "JavaClient/" + LDClient.CLIENT_VERSION).add("Accept", "text/event-stream").build();
        ConnectionErrorHandler connectionErrorHandler = new ConnectionErrorHandler(){

            @Override
            public ConnectionErrorHandler.Action onConnectionError(Throwable t) {
                if (t instanceof UnsuccessfulResponseException) {
                    int status = ((UnsuccessfulResponseException)t).getCode();
                    logger.error(Util.httpErrorMessage(status, "streaming connection", "will retry"));
                    if (!Util.isHttpErrorRecoverable(status)) {
                        initFuture.set(null);
                        return ConnectionErrorHandler.Action.SHUTDOWN;
                    }
                }
                return ConnectionErrorHandler.Action.PROCEED;
            }
        };
        EventHandler handler = new EventHandler(){

            @Override
            public void onOpen() throws Exception {
            }

            @Override
            public void onClosed() throws Exception {
            }

            @Override
            public void onMessage(String name, MessageEvent event) throws Exception {
                Gson gson = new Gson();
                switch (name) {
                    case "put": {
                        PutData putData = (PutData)gson.fromJson(event.getData(), PutData.class);
                        StreamProcessor.this.store.init(FeatureRequestor.toVersionedDataMap(putData.data));
                        if (StreamProcessor.this.initialized.getAndSet(true)) break;
                        initFuture.set(null);
                        logger.info("Initialized LaunchDarkly client.");
                        break;
                    }
                    case "patch": {
                        PatchData data = (PatchData)gson.fromJson(event.getData(), PatchData.class);
                        if (VersionedDataKind.FEATURES.getKeyFromStreamApiPath(data.path) != null) {
                            StreamProcessor.this.store.upsert(VersionedDataKind.FEATURES, (VersionedData)gson.fromJson(data.data, FeatureFlag.class));
                            break;
                        }
                        if (VersionedDataKind.SEGMENTS.getKeyFromStreamApiPath(data.path) == null) break;
                        StreamProcessor.this.store.upsert(VersionedDataKind.SEGMENTS, (VersionedData)gson.fromJson(data.data, Segment.class));
                        break;
                    }
                    case "delete": {
                        DeleteData data = (DeleteData)gson.fromJson(event.getData(), DeleteData.class);
                        String featureKey = VersionedDataKind.FEATURES.getKeyFromStreamApiPath(data.path);
                        if (featureKey != null) {
                            StreamProcessor.this.store.delete(VersionedDataKind.FEATURES, featureKey, data.version);
                            break;
                        }
                        String segmentKey = VersionedDataKind.SEGMENTS.getKeyFromStreamApiPath(data.path);
                        if (segmentKey == null) break;
                        StreamProcessor.this.store.delete(VersionedDataKind.SEGMENTS, segmentKey, data.version);
                        break;
                    }
                    case "indirect/put": {
                        try {
                            FeatureRequestor.AllData allData = StreamProcessor.this.requestor.getAllData();
                            StreamProcessor.this.store.init(FeatureRequestor.toVersionedDataMap(allData));
                            if (StreamProcessor.this.initialized.getAndSet(true)) break;
                            initFuture.set(null);
                            logger.info("Initialized LaunchDarkly client.");
                        }
                        catch (IOException e) {
                            logger.error("Encountered exception in LaunchDarkly client: {}", (Object)e.toString());
                            logger.debug(e.toString(), (Throwable)e);
                        }
                        break;
                    }
                    case "indirect/patch": {
                        String path = event.getData();
                        try {
                            String featureKey = VersionedDataKind.FEATURES.getKeyFromStreamApiPath(path);
                            if (featureKey != null) {
                                FeatureFlag feature = StreamProcessor.this.requestor.getFlag(featureKey);
                                StreamProcessor.this.store.upsert(VersionedDataKind.FEATURES, feature);
                                break;
                            }
                            String segmentKey = VersionedDataKind.SEGMENTS.getKeyFromStreamApiPath(path);
                            if (segmentKey == null) break;
                            Segment segment = StreamProcessor.this.requestor.getSegment(segmentKey);
                            StreamProcessor.this.store.upsert(VersionedDataKind.SEGMENTS, segment);
                        }
                        catch (IOException e) {
                            logger.error("Encountered exception in LaunchDarkly client: {}", (Object)e.toString());
                            logger.debug(e.toString(), (Throwable)e);
                        }
                        break;
                    }
                    default: {
                        logger.warn("Unexpected event found in stream: " + event.getData());
                    }
                }
            }

            @Override
            public void onComment(String comment) {
                logger.debug("Received a heartbeat");
            }

            @Override
            public void onError(Throwable throwable) {
                logger.warn("Encountered EventSource error: {}", (Object)throwable.toString());
                logger.debug(throwable.toString(), throwable);
            }
        };
        this.es = this.eventSourceCreator.createEventSource(handler, URI.create(this.config.streamURI.toASCIIString() + "/all"), connectionErrorHandler, headers);
        this.es.start();
        return initFuture;
    }

    @Override
    public void close() throws IOException {
        logger.info("Closing LaunchDarkly StreamProcessor");
        if (this.es != null) {
            this.es.close();
        }
        if (this.store != null) {
            this.store.close();
        }
    }

    @Override
    public boolean initialized() {
        return this.initialized.get();
    }

    private class DefaultEventSourceCreator
    implements EventSourceCreator {
        private DefaultEventSourceCreator() {
        }

        @Override
        public EventSource createEventSource(EventHandler handler, URI streamUri, ConnectionErrorHandler errorHandler, Headers headers) {
            EventSource.Builder builder = new EventSource.Builder(handler, streamUri).connectionErrorHandler(errorHandler).headers(headers).reconnectTimeMs(((StreamProcessor)StreamProcessor.this).config.reconnectTimeMs).connectTimeoutMs(((StreamProcessor)StreamProcessor.this).config.connectTimeoutMillis).readTimeoutMs(300000);
            if (((StreamProcessor)StreamProcessor.this).config.proxy != null) {
                builder.proxy(((StreamProcessor)StreamProcessor.this).config.proxy);
                if (((StreamProcessor)StreamProcessor.this).config.proxyAuthenticator != null) {
                    builder.proxyAuthenticator(((StreamProcessor)StreamProcessor.this).config.proxyAuthenticator);
                }
            }
            return builder.build();
        }
    }

    private static final class DeleteData {
        String path;
        int version;
    }

    private static final class PatchData {
        String path;
        JsonElement data;
    }

    private static final class PutData {
        FeatureRequestor.AllData data;
    }

    public static interface EventSourceCreator {
        public EventSource createEventSource(EventHandler var1, URI var2, ConnectionErrorHandler var3, Headers var4);
    }
}

