/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonPrimitive;
import com.launchdarkly.client.OperandType;
import java.util.regex.Pattern;

enum Operator {
    in{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            if (uValue.equals((Object)cValue)) {
                return true;
            }
            OperandType type = OperandType.bestGuess(uValue);
            if (type == OperandType.bestGuess(cValue)) {
                return Operator.compareValues(ComparisonOp.EQ, uValue, cValue, type);
            }
            return false;
        }
    }
    ,
    endsWith{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return uValue.isString() && cValue.isString() && uValue.getAsString().endsWith(cValue.getAsString());
        }
    }
    ,
    startsWith{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return uValue.isString() && cValue.isString() && uValue.getAsString().startsWith(cValue.getAsString());
        }
    }
    ,
    matches{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return uValue.isString() && cValue.isString() && Pattern.compile(cValue.getAsString()).matcher(uValue.getAsString()).find();
        }
    }
    ,
    contains{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return uValue.isString() && cValue.isString() && uValue.getAsString().contains(cValue.getAsString());
        }
    }
    ,
    lessThan{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return Operator.compareValues(ComparisonOp.LT, uValue, cValue, OperandType.number);
        }
    }
    ,
    lessThanOrEqual{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return Operator.compareValues(ComparisonOp.LTE, uValue, cValue, OperandType.number);
        }
    }
    ,
    greaterThan{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return Operator.compareValues(ComparisonOp.GT, uValue, cValue, OperandType.number);
        }
    }
    ,
    greaterThanOrEqual{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return Operator.compareValues(ComparisonOp.GTE, uValue, cValue, OperandType.number);
        }
    }
    ,
    before{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return Operator.compareValues(ComparisonOp.LT, uValue, cValue, OperandType.date);
        }
    }
    ,
    after{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return Operator.compareValues(ComparisonOp.GT, uValue, cValue, OperandType.date);
        }
    }
    ,
    semVerEqual{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return Operator.compareValues(ComparisonOp.EQ, uValue, cValue, OperandType.semVer);
        }
    }
    ,
    semVerLessThan{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return Operator.compareValues(ComparisonOp.LT, uValue, cValue, OperandType.semVer);
        }
    }
    ,
    semVerGreaterThan{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return Operator.compareValues(ComparisonOp.GT, uValue, cValue, OperandType.semVer);
        }
    }
    ,
    segmentMatch{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return false;
        }
    };


    abstract boolean apply(JsonPrimitive var1, JsonPrimitive var2);

    private static boolean compareValues(ComparisonOp op, JsonPrimitive uValue, JsonPrimitive cValue, OperandType asType) {
        Object uValueObj = asType.getValueAsType(uValue);
        Object cValueObj = asType.getValueAsType(cValue);
        return uValueObj != null && cValueObj != null && op.apply(uValueObj, cValueObj);
    }

    private static enum ComparisonOp {
        EQ,
        LT,
        LTE,
        GT,
        GTE;


        public boolean apply(Object a, Object b) {
            if (a instanceof Comparable && a.getClass() == b.getClass()) {
                int n = ((Comparable)a).compareTo(b);
                switch (this) {
                    case EQ: {
                        return n == 0;
                    }
                    case LT: {
                        return n < 0;
                    }
                    case LTE: {
                        return n <= 0;
                    }
                    case GT: {
                        return n > 0;
                    }
                    case GTE: {
                        return n >= 0;
                    }
                }
            }
            return false;
        }
    }
}

