/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.VersionedData;
import com.launchdarkly.client.VersionedDataKind;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableSortedMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

abstract class FeatureStoreDataSetSorter {
    private static Comparator<VersionedDataKind<?>> dataKindPriorityOrder = new Comparator<VersionedDataKind<?>>(){

        @Override
        public int compare(VersionedDataKind<?> o1, VersionedDataKind<?> o2) {
            return o1.getPriority() - o2.getPriority();
        }
    };

    FeatureStoreDataSetSorter() {
    }

    public static Map<VersionedDataKind<?>, Map<String, ? extends VersionedData>> sortAllCollections(Map<VersionedDataKind<?>, Map<String, ? extends VersionedData>> allData) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.orderedBy(dataKindPriorityOrder);
        for (Map.Entry<VersionedDataKind<?>, Map<String, VersionedData>> entry : allData.entrySet()) {
            VersionedDataKind<?> kind = entry.getKey();
            builder.put(kind, FeatureStoreDataSetSorter.sortCollection(kind, entry.getValue()));
        }
        return builder.build();
    }

    private static Map<String, ? extends VersionedData> sortCollection(VersionedDataKind<?> kind, Map<String, ? extends VersionedData> input) {
        if (!kind.isDependencyOrdered() || input.isEmpty()) {
            return input;
        }
        HashMap<String, VersionedData> remainingItems = new HashMap<String, VersionedData>(input);
        ImmutableMap.Builder<String, VersionedData> builder = ImmutableMap.builder();
        while (!remainingItems.isEmpty()) {
            Iterator iterator = remainingItems.entrySet().iterator();
            if (!iterator.hasNext()) continue;
            Map.Entry entry = iterator.next();
            FeatureStoreDataSetSorter.addWithDependenciesFirst(kind, (VersionedData)entry.getValue(), remainingItems, builder);
        }
        return builder.build();
    }

    private static void addWithDependenciesFirst(VersionedDataKind<?> kind, VersionedData item, Map<String, VersionedData> remainingItems, ImmutableMap.Builder<String, VersionedData> builder) {
        remainingItems.remove(item.getKey());
        for (String prereqKey : kind.getDependencyKeys(item)) {
            VersionedData prereqItem = remainingItems.get(prereqKey);
            if (prereqItem == null) continue;
            FeatureStoreDataSetSorter.addWithDependenciesFirst(kind, prereqItem, remainingItems, builder);
        }
        builder.put(item.getKey(), item);
    }
}

