/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class FeatureStoreCacheConfig {
    public static final long DEFAULT_TIME_SECONDS = 15L;
    public static final FeatureStoreCacheConfig DEFAULT = new FeatureStoreCacheConfig(15L, TimeUnit.SECONDS, StaleValuesPolicy.EVICT);
    private static final FeatureStoreCacheConfig DISABLED = new FeatureStoreCacheConfig(0L, TimeUnit.MILLISECONDS, StaleValuesPolicy.EVICT);
    private final long cacheTime;
    private final TimeUnit cacheTimeUnit;
    private final StaleValuesPolicy staleValuesPolicy;

    public static FeatureStoreCacheConfig disabled() {
        return DISABLED;
    }

    public static FeatureStoreCacheConfig enabled() {
        return DEFAULT;
    }

    private FeatureStoreCacheConfig(long cacheTime, TimeUnit cacheTimeUnit, StaleValuesPolicy staleValuesPolicy) {
        this.cacheTime = cacheTime;
        this.cacheTimeUnit = cacheTimeUnit;
        this.staleValuesPolicy = staleValuesPolicy;
    }

    public boolean isEnabled() {
        return this.getCacheTime() > 0L;
    }

    public long getCacheTime() {
        return this.cacheTime;
    }

    public TimeUnit getCacheTimeUnit() {
        return this.cacheTimeUnit;
    }

    public long getCacheTimeMillis() {
        return this.cacheTimeUnit.toMillis(this.cacheTime);
    }

    public StaleValuesPolicy getStaleValuesPolicy() {
        return this.staleValuesPolicy;
    }

    public FeatureStoreCacheConfig ttl(long cacheTime, TimeUnit timeUnit) {
        return new FeatureStoreCacheConfig(cacheTime, timeUnit, this.staleValuesPolicy);
    }

    public FeatureStoreCacheConfig ttlMillis(long millis) {
        return this.ttl(millis, TimeUnit.MILLISECONDS);
    }

    public FeatureStoreCacheConfig ttlSeconds(long seconds) {
        return this.ttl(seconds, TimeUnit.SECONDS);
    }

    public FeatureStoreCacheConfig staleValuesPolicy(StaleValuesPolicy policy) {
        return new FeatureStoreCacheConfig(this.cacheTime, this.cacheTimeUnit, policy);
    }

    public boolean equals(Object other) {
        if (other instanceof FeatureStoreCacheConfig) {
            FeatureStoreCacheConfig o = (FeatureStoreCacheConfig)other;
            return o.cacheTime == this.cacheTime && o.cacheTimeUnit == this.cacheTimeUnit && o.staleValuesPolicy == this.staleValuesPolicy;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cacheTime, this.cacheTimeUnit, this.staleValuesPolicy});
    }

    public static enum StaleValuesPolicy {
        EVICT,
        REFRESH,
        REFRESH_ASYNC;

    }
}

