/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.FeatureFlag;
import com.launchdarkly.client.HttpErrorException;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.Segment;
import com.launchdarkly.client.Util;
import com.launchdarkly.client.VersionedData;
import com.launchdarkly.client.VersionedDataKind;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.Response;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FeatureRequestor {
    private static final Logger logger = LoggerFactory.getLogger(FeatureRequestor.class);
    private static final String GET_LATEST_FLAGS_PATH = "/sdk/latest-flags";
    private static final String GET_LATEST_SEGMENTS_PATH = "/sdk/latest-segments";
    private static final String GET_LATEST_ALL_PATH = "/sdk/latest-all";
    private final String sdkKey;
    private final LDConfig config;

    FeatureRequestor(String sdkKey, LDConfig config) {
        this.sdkKey = sdkKey;
        this.config = config;
    }

    Map<String, FeatureFlag> getAllFlags() throws IOException, HttpErrorException {
        String body = this.get(GET_LATEST_FLAGS_PATH);
        return FeatureFlag.fromJsonMap(this.config, body);
    }

    FeatureFlag getFlag(String featureKey) throws IOException, HttpErrorException {
        String body = this.get("/sdk/latest-flags/" + featureKey);
        return FeatureFlag.fromJson(this.config, body);
    }

    Map<String, Segment> getAllSegments() throws IOException, HttpErrorException {
        String body = this.get(GET_LATEST_SEGMENTS_PATH);
        return Segment.fromJsonMap(this.config, body);
    }

    Segment getSegment(String segmentKey) throws IOException, HttpErrorException {
        String body = this.get("/sdk/latest-segments/" + segmentKey);
        return Segment.fromJson(this.config, body);
    }

    AllData getAllData() throws IOException, HttpErrorException {
        String body = this.get(GET_LATEST_ALL_PATH);
        return (AllData)this.config.gson.fromJson(body, AllData.class);
    }

    static Map<VersionedDataKind<?>, Map<String, ? extends VersionedData>> toVersionedDataMap(AllData allData) {
        HashMap ret = new HashMap();
        ret.put(VersionedDataKind.FEATURES, allData.flags);
        ret.put(VersionedDataKind.SEGMENTS, allData.segments);
        return ret;
    }

    private String get(String path) throws IOException, HttpErrorException {
        Request request = Util.getRequestBuilder(this.sdkKey).url(this.config.baseURI.toString() + path).get().build();
        logger.debug("Making request: " + request);
        try (Response response = this.config.httpClient.newCall(request).execute();){
            String body = response.body().string();
            if (!response.isSuccessful()) {
                throw new HttpErrorException(response.code());
            }
            logger.debug("Get flag(s) response: " + response.toString() + " with body: " + body);
            logger.debug("Network response: " + response.networkResponse());
            if (!this.config.stream) {
                logger.debug("Cache hit count: " + this.config.httpClient.cache().hitCount() + " Cache network Count: " + this.config.httpClient.cache().networkCount());
                logger.debug("Cache response: " + response.cacheResponse());
            }
            String string = body;
            return string;
        }
    }

    static class AllData {
        final Map<String, FeatureFlag> flags;
        final Map<String, Segment> segments;

        AllData(Map<String, FeatureFlag> flags, Map<String, Segment> segments) {
            this.flags = flags;
            this.segments = segments;
        }
    }
}

