/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.client.EvaluationDetail;
import com.launchdarkly.client.EvaluationReason;
import com.launchdarkly.client.FeatureFlag;
import com.launchdarkly.client.FlagsStateOption;
import com.launchdarkly.shaded.com.google.common.base.Objects;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonAdapter(value=JsonSerialization.class)
public class FeatureFlagsState {
    private static final Gson gson = new Gson();
    private final Map<String, JsonElement> flagValues;
    private final Map<String, FlagMetadata> flagMetadata;
    private final boolean valid;

    private FeatureFlagsState(Map<String, JsonElement> flagValues, Map<String, FlagMetadata> flagMetadata, boolean valid) {
        this.flagValues = Collections.unmodifiableMap(flagValues);
        this.flagMetadata = Collections.unmodifiableMap(flagMetadata);
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public JsonElement getFlagValue(String key) {
        return this.flagValues.get(key);
    }

    public EvaluationReason getFlagReason(String key) {
        FlagMetadata data = this.flagMetadata.get(key);
        return data == null ? null : data.reason;
    }

    public Map<String, JsonElement> toValuesMap() {
        return this.flagValues;
    }

    public boolean equals(Object other) {
        if (other instanceof FeatureFlagsState) {
            FeatureFlagsState o = (FeatureFlagsState)other;
            return this.flagValues.equals(o.flagValues) && this.flagMetadata.equals(o.flagMetadata) && this.valid == o.valid;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.flagValues, this.flagMetadata, this.valid);
    }

    static class JsonSerialization
    extends TypeAdapter<FeatureFlagsState> {
        JsonSerialization() {
        }

        public void write(JsonWriter out, FeatureFlagsState state) throws IOException {
            out.beginObject();
            for (Map.Entry entry : state.flagValues.entrySet()) {
                out.name((String)entry.getKey());
                gson.toJson((JsonElement)entry.getValue(), out);
            }
            out.name("$flagsState");
            gson.toJson((Object)state.flagMetadata, Map.class, out);
            out.name("$valid");
            out.value(state.valid);
            out.endObject();
        }

        public FeatureFlagsState read(JsonReader in) throws IOException {
            HashMap<String, JsonElement> flagValues = new HashMap<String, JsonElement>();
            HashMap<String, FlagMetadata> flagMetadata = new HashMap<String, FlagMetadata>();
            boolean valid = true;
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equals("$flagsState")) {
                    in.beginObject();
                    while (in.hasNext()) {
                        String metaName = in.nextName();
                        FlagMetadata meta = (FlagMetadata)gson.fromJson(in, FlagMetadata.class);
                        flagMetadata.put(metaName, meta);
                    }
                    in.endObject();
                    continue;
                }
                if (name.equals("$valid")) {
                    valid = in.nextBoolean();
                    continue;
                }
                JsonElement value = (JsonElement)gson.fromJson(in, JsonElement.class);
                flagValues.put(name, value);
            }
            in.endObject();
            return new FeatureFlagsState(flagValues, flagMetadata, valid);
        }
    }

    static class Builder {
        private Map<String, JsonElement> flagValues = new HashMap<String, JsonElement>();
        private Map<String, FlagMetadata> flagMetadata = new HashMap<String, FlagMetadata>();
        private final boolean saveReasons;
        private final boolean detailsOnlyForTrackedFlags;
        private boolean valid = true;

        Builder(FlagsStateOption ... options) {
            this.saveReasons = FlagsStateOption.hasOption(options, FlagsStateOption.WITH_REASONS);
            this.detailsOnlyForTrackedFlags = FlagsStateOption.hasOption(options, FlagsStateOption.DETAILS_ONLY_FOR_TRACKED_FLAGS);
        }

        Builder valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        Builder addFlag(FeatureFlag flag, EvaluationDetail<JsonElement> eval) {
            this.flagValues.put(flag.getKey(), eval.getValue());
            boolean flagIsTracked = flag.isTrackEvents() || flag.getDebugEventsUntilDate() != null && flag.getDebugEventsUntilDate() > System.currentTimeMillis();
            boolean wantDetails = !this.detailsOnlyForTrackedFlags || flagIsTracked;
            FlagMetadata data = new FlagMetadata(eval.getVariationIndex(), this.saveReasons && wantDetails ? eval.getReason() : null, wantDetails ? Integer.valueOf(flag.getVersion()) : null, flag.isTrackEvents(), flag.getDebugEventsUntilDate());
            this.flagMetadata.put(flag.getKey(), data);
            return this;
        }

        FeatureFlagsState build() {
            return new FeatureFlagsState(this.flagValues, this.flagMetadata, this.valid);
        }
    }

    static class FlagMetadata {
        final Integer variation;
        final EvaluationReason reason;
        final Integer version;
        final Boolean trackEvents;
        final Long debugEventsUntilDate;

        FlagMetadata(Integer variation, EvaluationReason reason, Integer version, boolean trackEvents, Long debugEventsUntilDate) {
            this.variation = variation;
            this.reason = reason;
            this.version = version;
            this.trackEvents = trackEvents ? Boolean.TRUE : null;
            this.debugEventsUntilDate = debugEventsUntilDate;
        }

        public boolean equals(Object other) {
            if (other instanceof FlagMetadata) {
                FlagMetadata o = (FlagMetadata)other;
                return Objects.equal(this.variation, o.variation) && Objects.equal(this.version, o.version) && Objects.equal(this.trackEvents, o.trackEvents) && Objects.equal(this.debugEventsUntilDate, o.debugEventsUntilDate);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.variation, this.version, this.trackEvents, this.debugEventsUntilDate);
        }
    }
}

