/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.media.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = GetMediaResponse.Builder.class
)
public final class GetMediaResponse {
  private final String mediaId;

  private final String contentType;

  private final int contentLength;

  private final OffsetDateTime uploadedAt;

  private final String url;

  private final String urlExpiry;

  private final Map<String, Object> additionalProperties;

  private GetMediaResponse(String mediaId, String contentType, int contentLength,
      OffsetDateTime uploadedAt, String url, String urlExpiry,
      Map<String, Object> additionalProperties) {
    this.mediaId = mediaId;
    this.contentType = contentType;
    this.contentLength = contentLength;
    this.uploadedAt = uploadedAt;
    this.url = url;
    this.urlExpiry = urlExpiry;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The unique langfuse identifier of a media record
   */
  @JsonProperty("mediaId")
  public String getMediaId() {
    return mediaId;
  }

  /**
   * @return The MIME type of the media record
   */
  @JsonProperty("contentType")
  public String getContentType() {
    return contentType;
  }

  /**
   * @return The size of the media record in bytes
   */
  @JsonProperty("contentLength")
  public int getContentLength() {
    return contentLength;
  }

  /**
   * @return The date and time when the media record was uploaded
   */
  @JsonProperty("uploadedAt")
  public OffsetDateTime getUploadedAt() {
    return uploadedAt;
  }

  /**
   * @return The download URL of the media record
   */
  @JsonProperty("url")
  public String getUrl() {
    return url;
  }

  /**
   * @return The expiry date and time of the media record download URL
   */
  @JsonProperty("urlExpiry")
  public String getUrlExpiry() {
    return urlExpiry;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof GetMediaResponse && equalTo((GetMediaResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(GetMediaResponse other) {
    return mediaId.equals(other.mediaId) && contentType.equals(other.contentType) && contentLength == other.contentLength && uploadedAt.equals(other.uploadedAt) && url.equals(other.url) && urlExpiry.equals(other.urlExpiry);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.mediaId, this.contentType, this.contentLength, this.uploadedAt, this.url, this.urlExpiry);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static MediaIdStage builder() {
    return new Builder();
  }

  public interface MediaIdStage {
    ContentTypeStage mediaId(@NotNull String mediaId);

    Builder from(GetMediaResponse other);
  }

  public interface ContentTypeStage {
    ContentLengthStage contentType(@NotNull String contentType);
  }

  public interface ContentLengthStage {
    UploadedAtStage contentLength(int contentLength);
  }

  public interface UploadedAtStage {
    UrlStage uploadedAt(@NotNull OffsetDateTime uploadedAt);
  }

  public interface UrlStage {
    UrlExpiryStage url(@NotNull String url);
  }

  public interface UrlExpiryStage {
    _FinalStage urlExpiry(@NotNull String urlExpiry);
  }

  public interface _FinalStage {
    GetMediaResponse build();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements MediaIdStage, ContentTypeStage, ContentLengthStage, UploadedAtStage, UrlStage, UrlExpiryStage, _FinalStage {
    private String mediaId;

    private String contentType;

    private int contentLength;

    private OffsetDateTime uploadedAt;

    private String url;

    private String urlExpiry;

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(GetMediaResponse other) {
      mediaId(other.getMediaId());
      contentType(other.getContentType());
      contentLength(other.getContentLength());
      uploadedAt(other.getUploadedAt());
      url(other.getUrl());
      urlExpiry(other.getUrlExpiry());
      return this;
    }

    /**
     * <p>The unique langfuse identifier of a media record</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("mediaId")
    public ContentTypeStage mediaId(@NotNull String mediaId) {
      this.mediaId = Objects.requireNonNull(mediaId, "mediaId must not be null");
      return this;
    }

    /**
     * <p>The MIME type of the media record</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("contentType")
    public ContentLengthStage contentType(@NotNull String contentType) {
      this.contentType = Objects.requireNonNull(contentType, "contentType must not be null");
      return this;
    }

    /**
     * <p>The size of the media record in bytes</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("contentLength")
    public UploadedAtStage contentLength(int contentLength) {
      this.contentLength = contentLength;
      return this;
    }

    /**
     * <p>The date and time when the media record was uploaded</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("uploadedAt")
    public UrlStage uploadedAt(@NotNull OffsetDateTime uploadedAt) {
      this.uploadedAt = Objects.requireNonNull(uploadedAt, "uploadedAt must not be null");
      return this;
    }

    /**
     * <p>The download URL of the media record</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("url")
    public UrlExpiryStage url(@NotNull String url) {
      this.url = Objects.requireNonNull(url, "url must not be null");
      return this;
    }

    /**
     * <p>The expiry date and time of the media record download URL</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("urlExpiry")
    public _FinalStage urlExpiry(@NotNull String urlExpiry) {
      this.urlExpiry = Objects.requireNonNull(urlExpiry, "urlExpiry must not be null");
      return this;
    }

    @java.lang.Override
    public GetMediaResponse build() {
      return new GetMediaResponse(mediaId, contentType, contentLength, uploadedAt, url, urlExpiry, additionalProperties);
    }
  }
}
