/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ConfigCategory.Builder.class
)
public final class ConfigCategory {
  private final double value;

  private final String label;

  private final Map<String, Object> additionalProperties;

  private ConfigCategory(double value, String label, Map<String, Object> additionalProperties) {
    this.value = value;
    this.label = label;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("value")
  public double getValue() {
    return value;
  }

  @JsonProperty("label")
  public String getLabel() {
    return label;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ConfigCategory && equalTo((ConfigCategory) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ConfigCategory other) {
    return value == other.value && label.equals(other.label);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.value, this.label);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static ValueStage builder() {
    return new Builder();
  }

  public interface ValueStage {
    LabelStage value(double value);

    Builder from(ConfigCategory other);
  }

  public interface LabelStage {
    _FinalStage label(@NotNull String label);
  }

  public interface _FinalStage {
    ConfigCategory build();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements ValueStage, LabelStage, _FinalStage {
    private double value;

    private String label;

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(ConfigCategory other) {
      value(other.getValue());
      label(other.getLabel());
      return this;
    }

    @java.lang.Override
    @JsonSetter("value")
    public LabelStage value(double value) {
      this.value = value;
      return this;
    }

    @java.lang.Override
    @JsonSetter("label")
    public _FinalStage label(@NotNull String label) {
      this.label = Objects.requireNonNull(label, "label must not be null");
      return this;
    }

    @java.lang.Override
    public ConfigCategory build() {
      return new ConfigCategory(value, label, additionalProperties);
    }
  }
}
