/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.annotationqueues.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = CreateAnnotationQueueItemRequest.Builder.class
)
public final class CreateAnnotationQueueItemRequest {
  private final String objectId;

  private final AnnotationQueueObjectType objectType;

  private final Optional<AnnotationQueueStatus> status;

  private final Map<String, Object> additionalProperties;

  private CreateAnnotationQueueItemRequest(String objectId, AnnotationQueueObjectType objectType,
      Optional<AnnotationQueueStatus> status, Map<String, Object> additionalProperties) {
    this.objectId = objectId;
    this.objectType = objectType;
    this.status = status;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("objectId")
  public String getObjectId() {
    return objectId;
  }

  @JsonProperty("objectType")
  public AnnotationQueueObjectType getObjectType() {
    return objectType;
  }

  /**
   * @return Defaults to PENDING for new queue items
   */
  @JsonProperty("status")
  public Optional<AnnotationQueueStatus> getStatus() {
    return status;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof CreateAnnotationQueueItemRequest && equalTo((CreateAnnotationQueueItemRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(CreateAnnotationQueueItemRequest other) {
    return objectId.equals(other.objectId) && objectType.equals(other.objectType) && status.equals(other.status);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.objectId, this.objectType, this.status);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static ObjectIdStage builder() {
    return new Builder();
  }

  public interface ObjectIdStage {
    ObjectTypeStage objectId(@NotNull String objectId);

    Builder from(CreateAnnotationQueueItemRequest other);
  }

  public interface ObjectTypeStage {
    _FinalStage objectType(@NotNull AnnotationQueueObjectType objectType);
  }

  public interface _FinalStage {
    CreateAnnotationQueueItemRequest build();

    _FinalStage status(Optional<AnnotationQueueStatus> status);

    _FinalStage status(AnnotationQueueStatus status);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements ObjectIdStage, ObjectTypeStage, _FinalStage {
    private String objectId;

    private AnnotationQueueObjectType objectType;

    private Optional<AnnotationQueueStatus> status = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(CreateAnnotationQueueItemRequest other) {
      objectId(other.getObjectId());
      objectType(other.getObjectType());
      status(other.getStatus());
      return this;
    }

    @java.lang.Override
    @JsonSetter("objectId")
    public ObjectTypeStage objectId(@NotNull String objectId) {
      this.objectId = Objects.requireNonNull(objectId, "objectId must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("objectType")
    public _FinalStage objectType(@NotNull AnnotationQueueObjectType objectType) {
      this.objectType = Objects.requireNonNull(objectType, "objectType must not be null");
      return this;
    }

    /**
     * <p>Defaults to PENDING for new queue items</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage status(AnnotationQueueStatus status) {
      this.status = Optional.ofNullable(status);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "status",
        nulls = Nulls.SKIP
    )
    public _FinalStage status(Optional<AnnotationQueueStatus> status) {
      this.status = status;
      return this;
    }

    @java.lang.Override
    public CreateAnnotationQueueItemRequest build() {
      return new CreateAnnotationQueueItemRequest(objectId, objectType, status, additionalProperties);
    }
  }
}
