/*
 * Decompiled with CFR 0.152.
 */
package emoji4j;

import ch.lambdaj.Lambda;
import emoji4j.AbstractEmoji;
import emoji4j.Emoji;
import emoji4j.EmojiManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hamcrest.Matchers;

public class EmojiUtils
extends AbstractEmoji {
    public static Emoji getEmoji(String code) {
        Matcher m = shortCodePattern.matcher(code);
        if (m.find()) {
            code = m.group(1);
        }
        Emoji emoji = (Emoji)Lambda.selectFirst(EmojiManager.data(), (org.hamcrest.Matcher)Lambda.having((Object)((Emoji)Lambda.on(Emoji.class)).getEmoji(), (org.hamcrest.Matcher)Matchers.equalTo((Object)code)).or((org.hamcrest.Matcher)Lambda.having((Object)((Emoji)Lambda.on(Emoji.class)).getEmoji(), (org.hamcrest.Matcher)Matchers.equalTo((Object)code))).or((org.hamcrest.Matcher)Lambda.having((Object)((Emoji)Lambda.on(Emoji.class)).getHexHtml(), (org.hamcrest.Matcher)Matchers.equalToIgnoringCase((String)code))).or((org.hamcrest.Matcher)Lambda.having((Object)((Emoji)Lambda.on(Emoji.class)).getDecimalHtml(), (org.hamcrest.Matcher)Matchers.equalToIgnoringCase((String)code))).or((org.hamcrest.Matcher)Lambda.having((Object)((Emoji)Lambda.on(Emoji.class)).getDecimalSurrogateHtml(), (org.hamcrest.Matcher)Matchers.equalToIgnoringCase((String)code))).or((org.hamcrest.Matcher)Lambda.having((Object)((Emoji)Lambda.on(Emoji.class)).getHexHtmlShort(), (org.hamcrest.Matcher)Matchers.equalToIgnoringCase((String)code))).or((org.hamcrest.Matcher)Lambda.having((Object)((Emoji)Lambda.on(Emoji.class)).getDecimalHtmlShort(), (org.hamcrest.Matcher)Matchers.equalToIgnoringCase((String)code))).or((org.hamcrest.Matcher)Lambda.having(((Emoji)Lambda.on(Emoji.class)).getAliases(), (org.hamcrest.Matcher)Matchers.hasItem((Object)code))).or((org.hamcrest.Matcher)Lambda.having(((Emoji)Lambda.on(Emoji.class)).getEmoticons(), (org.hamcrest.Matcher)Matchers.hasItem((Object)code))));
        return emoji;
    }

    public static boolean isEmoji(String code) {
        return EmojiUtils.getEmoji(code) != null;
    }

    public static String emojify(String text) {
        return EmojiUtils.emojify(text, 0);
    }

    private static String emojify(String text, int startIndex) {
        text = EmojiUtils.processStringWithRegex(text, shortCodeOrHtmlEntityPattern, startIndex, true);
        text = EmojiUtils.processStringWithRegex(text, EmojiManager.getEmoticonRegexPattern(), startIndex, true);
        return text;
    }

    private static String processStringWithRegex(String text, Pattern pattern, int startIndex, boolean recurseEmojify) {
        Matcher matcher = pattern.matcher(text);
        StringBuffer sb = new StringBuffer();
        int resetIndex = 0;
        if (startIndex > 0) {
            matcher.region(startIndex, text.length());
        }
        while (matcher.find()) {
            String emojiCode = matcher.group();
            Emoji emoji = EmojiUtils.getEmoji(emojiCode);
            if (emoji != null) {
                matcher.appendReplacement(sb, emoji.getEmoji());
                continue;
            }
            if (htmlSurrogateEntityPattern2.matcher(emojiCode).matches()) {
                String highSurrogate1 = matcher.group("H1");
                String highSurrogate2 = matcher.group("H2");
                String lowSurrogate1 = matcher.group("L1");
                String lowSurrogate2 = matcher.group("L2");
                matcher.appendReplacement(sb, EmojiUtils.processStringWithRegex(highSurrogate1 + highSurrogate2, shortCodeOrHtmlEntityPattern, 0, false));
                resetIndex = sb.toString().endsWith(highSurrogate2) ? sb.length() - highSurrogate2.length() : sb.length();
                sb.append(lowSurrogate1);
                sb.append(lowSurrogate2);
                break;
            }
            if (htmlSurrogateEntityPattern.matcher(emojiCode).matches()) {
                String highSurrogate = matcher.group("H");
                String lowSurrogate = matcher.group("L");
                matcher.appendReplacement(sb, EmojiUtils.processStringWithRegex(highSurrogate, htmlEntityPattern, 0, true));
                resetIndex = sb.length();
                sb.append(lowSurrogate);
                break;
            }
            matcher.appendReplacement(sb, emojiCode);
        }
        matcher.appendTail(sb);
        if (recurseEmojify && resetIndex > 0) {
            return EmojiUtils.emojify(sb.toString(), resetIndex);
        }
        return sb.toString();
    }

    public static int countEmojis(String text) {
        String htmlifiedText = EmojiUtils.htmlify(text);
        Matcher matcher = htmlEntityPattern.matcher(htmlifiedText);
        int counter = 0;
        while (matcher.find()) {
            String emojiCode = matcher.group();
            if (!EmojiUtils.isEmoji(emojiCode)) continue;
            ++counter;
        }
        return counter;
    }

    public static String htmlify(String text) {
        String emojifiedStr = EmojiUtils.emojify(text);
        return EmojiUtils.htmlifyHelper(emojifiedStr, false, false);
    }

    public static String htmlify(String text, boolean asSurrogate) {
        String emojifiedStr = EmojiUtils.emojify(text);
        return EmojiUtils.htmlifyHelper(emojifiedStr, false, asSurrogate);
    }

    public static String hexHtmlify(String text) {
        String emojifiedStr = EmojiUtils.emojify(text);
        return EmojiUtils.htmlifyHelper(emojifiedStr, true, false);
    }

    public static String shortCodify(String text) {
        String emojifiedText = EmojiUtils.emojify(text);
        for (Emoji emoji : EmojiManager.data()) {
            StringBuilder shortCodeBuilder = new StringBuilder();
            shortCodeBuilder.append(":").append(emoji.getAliases().get(0)).append(":");
            emojifiedText = emojifiedText.replace(emoji.getEmoji(), shortCodeBuilder.toString());
        }
        return emojifiedText;
    }

    public static String removeAllEmojis(String emojiText) {
        for (Emoji emoji : EmojiManager.data()) {
            emojiText = emojiText.replace(emoji.getEmoji(), "");
        }
        return emojiText;
    }
}

