/*
 * Decompiled with CFR 0.152.
 */
package emoji4j;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import emoji4j.Emoji;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class EmojiManager {
    private static Pattern emoticonRegexPattern;
    private static List<Emoji> emojiData;

    public static List<Emoji> data() {
        return emojiData;
    }

    public static Pattern getEmoticonRegexPattern() {
        return emoticonRegexPattern;
    }

    private static void processEmoticonsToRegex() {
        ArrayList<String> emoticons = new ArrayList<String>();
        for (Emoji e : emojiData) {
            if (e.getEmoticons() == null) continue;
            emoticons.addAll(e.getEmoticons());
        }
        for (int i = 0; i < emoticons.size(); ++i) {
            for (int j = i + 1; j < emoticons.size(); ++j) {
                String o1 = (String)emoticons.get(i);
                String o2 = (String)emoticons.get(j);
                if (!o2.contains(o1)) continue;
                String temp = o2;
                emoticons.remove(j);
                emoticons.add(i, temp);
            }
        }
        emoticonRegexPattern = EmojiManager.getAsciiEmojiRegex(emoticons);
    }

    public static void addStopWords(String ... stopwords) {
        if (stopwords == null || stopwords.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String stopword : stopwords) {
            sb.append(stopword);
            sb.append("|");
        }
        String emojiRegex = emoticonRegexPattern.toString();
        sb.append(emojiRegex);
        emoticonRegexPattern = Pattern.compile(sb.toString());
    }

    public static void clearStopWords() {
        EmojiManager.processEmoticonsToRegex();
    }

    private static Pattern getAsciiEmojiRegex(List<String> emojiList) {
        StringBuilder sb = new StringBuilder();
        for (String emoticon : emojiList) {
            if (sb.length() != 0) {
                sb.append("|");
            }
            sb.append(Pattern.quote(emoticon));
        }
        return Pattern.compile(sb.toString());
    }

    static {
        try {
            ObjectMapper mapper = new ObjectMapper();
            InputStream stream = EmojiManager.class.getResourceAsStream("/emoji.json");
            emojiData = (List)mapper.readValue(stream, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, Emoji.class));
            stream.close();
            EmojiManager.processEmoticonsToRegex();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

