/*
 * Decompiled with CFR 0.152.
 */
package emoji4j;

import java.util.regex.Pattern;

public abstract class AbstractEmoji {
    protected static final Pattern shortCodePattern = Pattern.compile(":(\\w+):");
    protected static final Pattern htmlEntityPattern = Pattern.compile("&#\\w+;");
    protected static final Pattern htmlSurrogateEntityPattern = Pattern.compile("(?<H>&#\\w+;)(?<L>&#\\w+;)");
    protected static final Pattern htmlSurrogateEntityPattern2 = Pattern.compile("&#\\w+;&#\\w+;&#\\w+;&#\\w+;");
    protected static final Pattern shortCodeOrHtmlEntityPattern = Pattern.compile(":\\w+:|(?<H1>&#\\w+;)(?<H2>&#\\w+;)(?<L1>&#\\w+;)(?<L2>&#\\w+;)|(?<H>&#\\w+;)(?<L>&#\\w+;)|&#\\w+;");

    protected static String htmlifyHelper(String text, boolean isHex, boolean isSurrogate) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            int ch = text.codePointAt(i);
            if (ch <= 128) {
                sb.appendCodePoint(ch);
                continue;
            }
            if (ch > 128 && (ch < 159 || ch >= 55296 && ch <= 57343)) continue;
            if (isHex) {
                sb.append("&#x" + Integer.toHexString(ch) + ";");
                continue;
            }
            if (isSurrogate) {
                double H = Math.floor((ch - 65536) / 1024) + 55296.0;
                double L = (ch - 65536) % 1024 + 56320;
                sb.append("&#" + String.format("%.0f", H) + ";&#" + String.format("%.0f", L) + ";");
                continue;
            }
            sb.append("&#" + ch + ";");
        }
        return sb.toString();
    }
}

