/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.mobile.components;

import com.jgeppert.struts2.jquery.mobile.components.ThemeableBean;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.components.TextField;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="slider", tldTagClass="com.jgeppert.struts2.jquery.mobile.views.jsp.ui.SliderTag", description="Renders a slider field", allowDynamicAttributes=true)
public class Slider
extends TextField
implements ThemeableBean {
    public static final String TEMPLATE = "slider";
    public static final String COMPONENT_NAME = Slider.class.getName();
    private static final transient Random RANDOM = new Random();
    private static final String PARAM_DATA_THEME = "dataTheme";
    private static final String PARAM_MAX = "max";
    private static final String PARAM_MIN = "min";
    private static final String PARAM_STEP = "step";
    private static final String PARAM_ID = "id";
    private static final String ID_PREFIX_SLIDER = "slider_";
    protected String dataTheme;
    protected String max;
    protected String min;
    protected String step;

    public Slider(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    public void evaluateExtraParams() {
        super.evaluateExtraParams();
        if (this.dataTheme != null) {
            this.addParameter(PARAM_DATA_THEME, this.findString(this.dataTheme));
        }
        if (this.max != null) {
            this.addParameter(PARAM_MAX, this.findValue(this.max, Integer.class));
        }
        if (this.min != null) {
            this.addParameter(PARAM_MIN, this.findValue(this.min, Integer.class));
        }
        if (this.step != null) {
            this.addParameter(PARAM_STEP, this.findValue(this.step, Integer.class));
        }
        if (this.id == null || this.id.length() == 0) {
            int nextInt = RANDOM.nextInt();
            nextInt = nextInt == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(nextInt);
            this.id = ID_PREFIX_SLIDER + String.valueOf(nextInt);
            this.addParameter(PARAM_ID, this.id);
        }
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "mobile";
    }

    @StrutsTagAttribute(description="Initialize a slider with the max option specified. Default: 100", type="Integer")
    public void setMax(String max) {
        this.max = max;
    }

    @StrutsTagAttribute(description="The minimum value of the slider. Default: 0", type="Integer")
    public void setMin(String min) {
        this.min = min;
    }

    @StrutsTagAttribute(description="Determines the size or amount of each interval or step the slider takes between min and max. The full specified value range of the slider (max - min) needs to be evenly divisible by the step. Default: 1", type="Integer")
    public void setStep(String step) {
        this.step = step;
    }

    @Override
    @StrutsTagAttribute(description="Set the Slider theme. e.g. a,b,c,d or e")
    public void setDataTheme(String dataTheme) {
        this.dataTheme = dataTheme;
    }
}

