/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.mobile.components;

import com.jgeppert.struts2.jquery.mobile.components.ThemeableBean;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.components.ClosingUIBean;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="div", tldTagClass="com.jgeppert.struts2.jquery.mobile.views.jsp.ui.DivTag", description="Render HTML div element", allowDynamicAttributes=true)
public class Div
extends ClosingUIBean
implements ThemeableBean {
    public static final String TEMPLATE = "div";
    public static final String TEMPLATE_CLOSE = "div-close";
    public static final String COMPONENT_NAME = Div.class.getName();
    private static final transient Random RANDOM = new Random();
    private static final String PARAM_DATA_THEME = "dataTheme";
    private static final String PARAM_ROLE = "role";
    private static final String PARAM_ID = "id";
    private static final String ID_PREFIX_DIV = "div_";
    protected String role;
    protected String dataTheme;

    public Div(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public String getDefaultOpenTemplate() {
        return TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE_CLOSE;
    }

    public void evaluateExtraParams() {
        super.evaluateExtraParams();
        if (this.role != null) {
            this.addParameter(PARAM_ROLE, this.findString(this.role));
        }
        if (this.dataTheme != null) {
            this.addParameter(PARAM_DATA_THEME, this.findString(this.dataTheme));
        }
        if (this.id == null || this.id.length() == 0) {
            int nextInt = RANDOM.nextInt();
            nextInt = nextInt == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(nextInt);
            this.id = ID_PREFIX_DIV + String.valueOf(nextInt);
            this.addParameter(PARAM_ID, this.id);
        }
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "mobile";
    }

    @StrutsTagAttribute(description="div role. e.g.: page, header, content, footer")
    public void setRole(String role) {
        this.role = role;
    }

    @Override
    @StrutsTagAttribute(description="set the div theme. e.g. a,b,c,d or e")
    public void setDataTheme(String dataTheme) {
        this.dataTheme = dataTheme;
    }
}

