/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.wxaapp.jfinal;

import com.jfinal.aop.Before;
import com.jfinal.core.Controller;
import com.jfinal.ext.interceptor.NotAction;
import com.jfinal.kit.HttpKit;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Log;
import com.jfinal.weixin.sdk.kit.MsgEncryptKit;
import com.jfinal.wxaapp.WxaConfigKit;
import com.jfinal.wxaapp.jfinal.WxaMsgInterceptor;
import com.jfinal.wxaapp.msg.IMsgParser;
import com.jfinal.wxaapp.msg.bean.WxaImageMsg;
import com.jfinal.wxaapp.msg.bean.WxaMsg;
import com.jfinal.wxaapp.msg.bean.WxaTextMsg;
import com.jfinal.wxaapp.msg.bean.WxaUserEnterSessionMsg;
import javax.servlet.http.HttpServletRequest;

public abstract class WxaMsgController
extends Controller {
    private static final Log log = Log.getLog(WxaMsgController.class);
    private String wxaMsgXml = null;
    private WxaMsg wxaMsg = null;

    @Before(value={WxaMsgInterceptor.class})
    public void index() {
        WxaMsg wxaMsg;
        if (WxaConfigKit.isDevMode()) {
            System.out.println("\u63a5\u6536\u6d88\u606f:");
            System.out.println(this.getWxaMsgXml());
        }
        if ((wxaMsg = this.getWxaMsg()) instanceof WxaTextMsg) {
            this.processTextMsg((WxaTextMsg)wxaMsg);
        } else if (wxaMsg instanceof WxaImageMsg) {
            this.processImageMsg((WxaImageMsg)wxaMsg);
        } else if (wxaMsg instanceof WxaUserEnterSessionMsg) {
            this.processUserEnterSessionMsg((WxaUserEnterSessionMsg)wxaMsg);
        } else {
            log.error("\u672a\u80fd\u8bc6\u522b\u7684\u5c0f\u7a0b\u5e8f\u6d88\u606f\u7c7b\u578b\u3002 \u6d88\u606f\u5185\u5bb9\u4e3a\uff1a\n" + this.getWxaMsgXml());
        }
        this.renderText("success");
    }

    @Before(value={NotAction.class})
    public String getWxaMsgXml() {
        if (this.wxaMsgXml == null) {
            this.wxaMsgXml = HttpKit.readData((HttpServletRequest)this.getRequest());
            if (WxaConfigKit.getWxaConfig().isMessageEncrypt()) {
                this.wxaMsgXml = MsgEncryptKit.decrypt(this.wxaMsgXml, this.getPara("timestamp"), this.getPara("nonce"), this.getPara("msg_signature"));
            }
        }
        if (StrKit.isBlank((String)this.wxaMsgXml)) {
            throw new RuntimeException("\u8bf7\u4e0d\u8981\u5728\u6d4f\u89c8\u5668\u4e2d\u8bf7\u6c42\u8be5\u8fde\u63a5,\u8c03\u8bd5\u8bf7\u67e5\u770bWIKI:http://git.oschina.net/jfinal/jfinal-weixin/wikis/JFinal-weixin-demo%E5%92%8C%E8%B0%83%E8%AF%95");
        }
        return this.wxaMsgXml;
    }

    @Before(value={NotAction.class})
    public WxaMsg getWxaMsg() {
        if (this.wxaMsg == null) {
            IMsgParser msgParser = WxaConfigKit.getMsgParser();
            this.wxaMsg = msgParser.parser(this.wxaMsgXml);
        }
        return this.wxaMsg;
    }

    protected abstract void processTextMsg(WxaTextMsg var1);

    protected abstract void processImageMsg(WxaImageMsg var1);

    protected abstract void processUserEnterSessionMsg(WxaUserEnterSessionMsg var1);
}

