/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.integration.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DavStaticFileServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_STREAM_BUFFER_SIZE = 10240;
    private static final Long DEFAULT_EXPIRE_TIME_IN_SECONDS = TimeUnit.DAYS.toSeconds(1L);
    private static final long ONE_SECOND_IN_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final String ETAG = "W/\"%s-%s\"";
    private static final Pattern RANGE_PATTERN = Pattern.compile("^bytes=[0-9]*-[0-9]*(,[0-9]*-[0-9]*)*$");
    private static final String MULTIPART_BOUNDARY = UUID.randomUUID().toString();
    private static final Set<String> DEFAULT_MIMETYPES = new HashSet<String>(Arrays.asList("text/plain", "text/html", "text/xml", "text/css", "text/javascript", "text/csv", "text/rtf", "application/xml", "application/xhtml+xml", "application/javascript", "application/json", "image/svg+xml"));
    private File folder;

    public void init(ServletConfig servletConfig) {
        this.folder = new File(servletConfig.getServletContext().getRealPath("/"), "WEB-INF");
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doRequest(request, response, true);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doRequest(request, response, false);
    }

    private void doRequest(HttpServletRequest request, HttpServletResponse response, boolean head) throws IOException {
        Resource resource;
        response.reset();
        try {
            resource = new Resource(this.getFile(request));
        }
        catch (IllegalArgumentException e) {
            response.sendError(400);
            return;
        }
        if (resource.file == null) {
            this.handleFileNotFound(response);
            return;
        }
        if (this.preconditionFailed(request, resource)) {
            response.sendError(412);
            return;
        }
        this.setCacheHeaders(response, resource, this.getExpireTime());
        if (this.notModified(request, resource)) {
            response.setStatus(304);
            return;
        }
        List<Range> ranges = this.getRanges(request, resource);
        if (ranges == null) {
            response.setHeader("Content-Range", "bytes */" + resource.length);
            response.sendError(416);
            return;
        }
        if (!ranges.isEmpty()) {
            response.setStatus(206);
        } else {
            ranges.add(new Range(0L, resource.length - 1L));
        }
        String contentType = this.setContentHeaders(request, response, resource, ranges);
        if (head) {
            return;
        }
        boolean acceptsGzip = false;
        if (DEFAULT_MIMETYPES.contains(contentType.split(";", 2)[0])) {
            String acceptEncoding = request.getHeader("Accept-Encoding");
            acceptsGzip = acceptEncoding != null && DavStaticFileServlet.accepts(acceptEncoding, "gzip");
            contentType = contentType + ";charset=UTF-8";
        }
        this.writeContent(response, resource, ranges, contentType, acceptsGzip);
    }

    private File getFile(HttpServletRequest request) throws IllegalArgumentException {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (servletPath == null || servletPath.isEmpty() || pathInfo == null || pathInfo.isEmpty() || "/".equals(pathInfo)) {
            throw new IllegalArgumentException();
        }
        return Paths.get(this.folder.getAbsolutePath(), servletPath, pathInfo).toFile();
    }

    private void handleFileNotFound(HttpServletResponse response) throws IOException {
        response.sendError(404);
    }

    private long getExpireTime() {
        return DEFAULT_EXPIRE_TIME_IN_SECONDS;
    }

    private String getContentType(HttpServletRequest request, File file) {
        return this.coalesce(request.getServletContext().getMimeType(file.getName()), "application/octet-stream");
    }

    private boolean isAttachment(HttpServletRequest request, String contentType) {
        String accept = request.getHeader("Accept");
        return !this.startsWithOneOf(contentType, "text", "image") && (accept == null || !DavStaticFileServlet.accepts(accept, contentType));
    }

    private String getAttachmentName(File file) {
        return file.getName();
    }

    private boolean preconditionFailed(HttpServletRequest request, Resource resource) {
        String match = request.getHeader("If-Match");
        long unmodified = request.getDateHeader("If-Unmodified-Since");
        return match != null ? !DavStaticFileServlet.matches(match, resource.eTag) : unmodified != -1L && DavStaticFileServlet.modified(unmodified, resource.lastModified);
    }

    private void setCacheHeaders(HttpServletResponse response, Resource resource, long expires) {
        this.setCacheHeaders(response, expires);
        response.setHeader("ETag", resource.eTag);
        response.setDateHeader("Last-Modified", resource.lastModified);
    }

    private boolean notModified(HttpServletRequest request, Resource resource) {
        String noMatch = request.getHeader("If-None-Match");
        long modified = request.getDateHeader("If-Modified-Since");
        return noMatch != null ? DavStaticFileServlet.matches(noMatch, resource.eTag) : modified != -1L && !DavStaticFileServlet.modified(modified, resource.lastModified);
    }

    private List<Range> getRanges(HttpServletRequest request, Resource resource) {
        ArrayList<Range> ranges = new ArrayList<Range>(1);
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader == null) {
            return ranges;
        }
        if (!RANGE_PATTERN.matcher(rangeHeader).matches()) {
            return Collections.emptyList();
        }
        String ifRange = request.getHeader("If-Range");
        if (ifRange != null && !ifRange.equals(resource.eTag)) {
            try {
                long ifRangeTime = request.getDateHeader("If-Range");
                if (ifRangeTime != -1L && DavStaticFileServlet.modified(ifRangeTime, resource.lastModified)) {
                    return ranges;
                }
            }
            catch (IllegalArgumentException ifRangeHeaderIsInvalid) {
                return ranges;
            }
        }
        for (String rangeHeaderPart : rangeHeader.split("=")[1].split(",")) {
            Range range = this.parseRange(rangeHeaderPart, resource.length);
            if (range == null) {
                return Collections.emptyList();
            }
            ranges.add(range);
        }
        return ranges;
    }

    private Range parseRange(String range, long length) {
        long start = DavStaticFileServlet.sublong(range, 0, range.indexOf(45));
        long end = DavStaticFileServlet.sublong(range, range.indexOf(45) + 1, range.length());
        if (start == -1L) {
            start = length - end;
            end = length - 1L;
        } else if (end == -1L || end > length - 1L) {
            end = length - 1L;
        }
        if (start > end) {
            return null;
        }
        return new Range(start, end);
    }

    private String setContentHeaders(HttpServletRequest request, HttpServletResponse response, Resource resource, List<Range> ranges) {
        String contentType = this.getContentType(request, resource.file);
        String filename = this.getAttachmentName(resource.file);
        boolean attachment = this.isAttachment(request, contentType);
        response.setHeader("Content-Disposition", this.formatContentDispositionHeader(filename, attachment));
        response.setHeader("Accept-Ranges", "bytes");
        if (ranges.size() == 1) {
            Range range = ranges.get(0);
            response.setContentType(contentType);
            if (response.getStatus() == 206) {
                response.setHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + resource.length);
            }
        } else {
            response.setContentType("multipart/byteranges; boundary=" + MULTIPART_BOUNDARY);
        }
        return contentType;
    }

    private void writeContent(HttpServletResponse response, Resource resource, List<Range> ranges, String contentType, boolean acceptsGzip) throws IOException {
        ServletOutputStream output = response.getOutputStream();
        if (ranges.size() == 1) {
            Range range = ranges.get(0);
            if (acceptsGzip) {
                response.setHeader("Content-Encoding", "gzip");
                this.stream(resource.file, new GZIPOutputStream((OutputStream)output, 10240), range.start, range.length);
            } else {
                response.setHeader("Content-Length", String.valueOf(range.length));
                this.stream(resource.file, (OutputStream)output, range.start, range.length);
            }
        } else {
            for (Range range : ranges) {
                output.println();
                output.println("--" + MULTIPART_BOUNDARY);
                output.println("Content-Type: " + contentType);
                output.println("Content-Range: bytes " + range.start + "-" + range.end + "/" + resource.length);
                this.stream(resource.file, (OutputStream)output, range.start, range.length);
            }
            output.println();
            output.println("--" + MULTIPART_BOUNDARY + "--");
        }
    }

    private static boolean matches(String matchHeader, String eTag) {
        Object[] matchValues = matchHeader.split("\\s*,\\s*");
        Arrays.sort(matchValues);
        return Arrays.binarySearch(matchValues, eTag) > -1 || Arrays.binarySearch(matchValues, "*") > -1;
    }

    private static boolean modified(long modifiedHeader, long lastModified) {
        return modifiedHeader + ONE_SECOND_IN_MILLIS <= lastModified;
    }

    private static long sublong(String value, int beginIndex, int endIndex) {
        String substring = value.substring(beginIndex, endIndex);
        return substring.isEmpty() ? -1L : Long.parseLong(substring);
    }

    private static boolean accepts(String acceptHeader, String toAccept) {
        Object[] acceptValues = acceptHeader.split("\\s*(,|;)\\s*");
        Arrays.sort(acceptValues);
        return Arrays.binarySearch(acceptValues, toAccept) > -1 || Arrays.binarySearch(acceptValues, toAccept.replaceAll("/.*$", "/*")) > -1 || Arrays.binarySearch(acceptValues, "*/*") > -1;
    }

    @SafeVarargs
    private final <T> T coalesce(T ... objects) {
        for (T object : objects) {
            if (object == null) continue;
            return object;
        }
        return null;
    }

    private static String encodeURL(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("UTF-8 is apparently not supported on this platform.", e);
        }
    }

    private boolean startsWithOneOf(String string, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!string.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private void setCacheHeaders(HttpServletResponse response, long expires) {
        if (expires > 0L) {
            response.setHeader("Cache-Control", "public,max-age=" + expires + ",must-revalidate");
            response.setDateHeader("Expires", System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(expires));
            response.setHeader("Pragma", "");
        } else {
            this.setNoCacheHeaders(response);
        }
    }

    private void setNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
        response.setDateHeader("Expires", 0L);
        response.setHeader("Pragma", "no-cache");
    }

    private String formatContentDispositionHeader(String filename, boolean attachment) {
        return String.format("%s;filename=\"%2$s\"; filename*=UTF-8''%2$s", attachment ? "attachment" : "inline", this.encodeURI(filename));
    }

    private String encodeURI(String string) {
        if (string == null) {
            return null;
        }
        return DavStaticFileServlet.encodeURL(string).replace("+", "%20").replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%7E", "~");
    }

    private long stream(InputStream input, OutputStream output) throws IOException {
        try (ReadableByteChannel inputChannel = Channels.newChannel(input);){
            long l;
            block13: {
                WritableByteChannel outputChannel = Channels.newChannel(output);
                try {
                    ByteBuffer buffer = ByteBuffer.allocateDirect(10240);
                    long size = 0L;
                    while (inputChannel.read(buffer) != -1) {
                        buffer.flip();
                        size += (long)outputChannel.write(buffer);
                        buffer.clear();
                    }
                    l = size;
                    if (outputChannel == null) break block13;
                }
                catch (Throwable throwable) {
                    if (outputChannel != null) {
                        try {
                            outputChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outputChannel.close();
            }
            return l;
        }
    }

    private long stream(File file, OutputStream output, long start, long length) throws IOException {
        if (start == 0L && length >= file.length()) {
            return this.stream(new FileInputStream(file), output);
        }
        try (FileChannel fileChannel = (FileChannel)Files.newByteChannel(file.toPath(), StandardOpenOption.READ);){
            WritableByteChannel outputChannel = Channels.newChannel(output);
            ByteBuffer buffer = ByteBuffer.allocateDirect(10240);
            long size = 0L;
            while (fileChannel.read(buffer, start + size) != -1) {
                buffer.flip();
                if (size + (long)buffer.limit() > length) {
                    buffer.limit((int)(length - size));
                }
                if ((size += (long)outputChannel.write(buffer)) >= length) break;
                buffer.clear();
            }
            long l = size;
            return l;
        }
    }

    private static class Resource {
        private final File file;
        private final long length;
        private final long lastModified;
        private final String eTag;

        public Resource(File file) {
            if (file != null && file.isFile()) {
                this.file = file;
                this.length = file.length();
                this.lastModified = file.lastModified();
                this.eTag = String.format(DavStaticFileServlet.ETAG, DavStaticFileServlet.encodeURL(file.getName()), this.lastModified);
            } else {
                this.file = null;
                this.length = 0L;
                this.lastModified = 0L;
                this.eTag = null;
            }
        }
    }

    private static class Range {
        private final long start;
        private final long end;
        private final long length;

        public Range(long start, long end) {
            this.start = start;
            this.end = end;
            this.length = end - start + 1L;
        }
    }
}

