/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.integration.extendedattributes;

import com.ithit.webdav.integration.extendedattributes.ExtendedAttribute;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.List;

class DefaultExtendedAttribute
implements ExtendedAttribute {
    DefaultExtendedAttribute() {
    }

    @Override
    public void setExtendedAttribute(String path, String attribName, String attribValue) throws IOException {
        Path sysPath = Paths.get(path, new String[0]);
        FileTime lastWriteTime = Files.getLastModifiedTime(sysPath, LinkOption.NOFOLLOW_LINKS);
        UserDefinedFileAttributeView view = Files.getFileAttributeView(sysPath, UserDefinedFileAttributeView.class, new LinkOption[0]);
        view.write(attribName, Charset.defaultCharset().encode(attribValue));
        Files.setLastModifiedTime(sysPath, lastWriteTime);
    }

    @Override
    public String getExtendedAttribute(String path, String attribName) throws IOException {
        UserDefinedFileAttributeView view = Files.getFileAttributeView(Paths.get(path, new String[0]), UserDefinedFileAttributeView.class, new LinkOption[0]);
        List<String> attrNames = view.list();
        for (String existAttrName : attrNames) {
            if (!existAttrName.equals(attribName)) continue;
            ByteBuffer buf = ByteBuffer.allocate(view.size(attribName));
            view.read(attribName, buf);
            ((Buffer)buf).flip();
            return Charset.defaultCharset().decode(buf).toString();
        }
        return null;
    }

    @Override
    public void deleteExtendedAttribute(String path, String attribName) throws IOException {
        UserDefinedFileAttributeView view = Files.getFileAttributeView(Paths.get(path, new String[0]), UserDefinedFileAttributeView.class, new LinkOption[0]);
        view.delete(attribName);
    }
}

