/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.jsoup.parser;

import com.itextpdf.styledxmlparser.jsoup.parser.CharacterReader;
import com.itextpdf.styledxmlparser.jsoup.parser.Token;
import com.itextpdf.styledxmlparser.jsoup.parser.Tokeniser;

abstract class TokeniserState {
    static TokeniserState Data = new DataTS();
    static TokeniserState CharacterReferenceInData = new CharacterReferenceInDataTS();
    static TokeniserState Rcdata = new RcDataTS();
    static TokeniserState CharacterReferenceInRcdata = new CharacterReferenceInRcdataTS();
    static TokeniserState Rawtext = new RawTextTS();
    static TokeniserState ScriptData = new ScriptDataTS();
    static TokeniserState PLAINTEXT = new PlainTextTS();
    static TokeniserState TagOpen = new TagOpenTS();
    static TokeniserState EndTagOpen = new EndTagOpenTS();
    static TokeniserState TagName = new TagNameTS();
    static TokeniserState RcdataLessthanSign = new RcDataLessThanSignTS();
    static TokeniserState RCDATAEndTagOpen = new RcDataEndTagOpenTS();
    static TokeniserState RCDATAEndTagName = new RcDataEndTagNameTS();
    static TokeniserState RawtextLessthanSign = new RawTextLessThanSignTS();
    static TokeniserState RawtextEndTagOpen = new RawTextEndTagOpenTS();
    static TokeniserState RawtextEndTagName = new RawTextEndTagNameTS();
    static TokeniserState ScriptDataLessthanSign = new ScriptDataLessThanSignTS();
    static TokeniserState ScriptDataEndTagOpen = new ScriptDataEndTagOpenTS();
    static TokeniserState ScriptDataEndTagName = new ScriptDataEndTagNameTS();
    static TokeniserState ScriptDataEscapeStart = new ScriptDataEscapeStartTS();
    static TokeniserState ScriptDataEscapeStartDash = new ScriptDataEscapeStartDashTS();
    static TokeniserState ScriptDataEscaped = new ScriptDataEscapedTS();
    static TokeniserState ScriptDataEscapedDash = new ScriptDataEscapedDashTS();
    static TokeniserState ScriptDataEscapedDashDash = new ScriptDataEscapedDashDashTS();
    static TokeniserState ScriptDataEscapedLessthanSign = new ScriptDataEscapedLessThanSignTS();
    static TokeniserState ScriptDataEscapedEndTagOpen = new ScriptDataEscapedEndTagOpenTS();
    static TokeniserState ScriptDataEscapedEndTagName = new ScriptDataEscapedEndTagNameTS();
    static TokeniserState ScriptDataDoubleEscapeStart = new ScriptDataDoubleEscapeStartTS();
    static TokeniserState ScriptDataDoubleEscaped = new ScriptDataDoubleEscapedTS();
    static TokeniserState ScriptDataDoubleEscapedDash = new ScriptDataDoubleEscapedDashTS();
    static TokeniserState ScriptDataDoubleEscapedDashDash = new ScriptDataDoubleEscapedDashDashTS();
    static TokeniserState ScriptDataDoubleEscapedLessthanSign = new ScriptDataDoubleEscapedLessThanSignTS();
    static TokeniserState ScriptDataDoubleEscapeEnd = new ScriptDataDoubleEscapeEndTS();
    static TokeniserState BeforeAttributeName = new BeforeAttributeNameTS();
    static TokeniserState AttributeName = new AttributeNameTS();
    static TokeniserState AfterAttributeName = new AfterAttributeNameTS();
    static TokeniserState BeforeAttributeValue = new BeforeAttributeValueTS();
    static TokeniserState AttributeValue_doubleQuoted = new AttributeValueDoubleQuotedTS();
    static TokeniserState AttributeValue_singleQuoted = new AttributeValueSingleQuotedTS();
    static TokeniserState AttributeValue_unquoted = new AttributeValueUnquotedTS();
    static TokeniserState AfterAttributeValue_quoted = new AfterAttributeValueQuotedTS();
    static TokeniserState SelfClosingStartTag = new SelfClosingStartTagTS();
    static TokeniserState BogusComment = new BogusCommentTS();
    static TokeniserState MarkupDeclarationOpen = new MarkupDeclarationOpenTS();
    static TokeniserState CommentStart = new CommentStartTS();
    static TokeniserState CommentStartDash = new CommentStartDashTS();
    static TokeniserState Comment = new CommentTS();
    static TokeniserState CommentEndDash = new CommentEndDashTS();
    static TokeniserState CommentEnd = new CommentEndTS();
    static TokeniserState CommentEndBang = new CommentEndBangTS();
    static TokeniserState Doctype = new DocTypeTS();
    static TokeniserState BeforeDoctypeName = new BeforeDocTypeNameTS();
    static TokeniserState DoctypeName = new DocTypeNameTS();
    static TokeniserState AfterDoctypeName = new AfterDocTypeNameTS();
    static TokeniserState AfterDoctypePublicKeyword = new AfterDocTypePublicKeywordTS();
    static TokeniserState BeforeDoctypePublicIdentifier = new BeforeDocTypePublicIdentifierTS();
    static TokeniserState DoctypePublicIdentifier_doubleQuoted = new DocTypePublicIdentifierDoubleQuotedTS();
    static TokeniserState DoctypePublicIdentifier_singleQuoted = new DocTypePublicIdentifierSingleQuotedTS();
    static TokeniserState AfterDoctypePublicIdentifier = new AfterDocTypePublicIdentifierTS();
    static TokeniserState BetweenDoctypePublicAndSystemIdentifiers = new BetweenDocTypePublicAndSystemIdentifiersTS();
    static TokeniserState AfterDoctypeSystemKeyword = new AfterDocTypeSystemKeywordTS();
    static TokeniserState BeforeDoctypeSystemIdentifier = new BeforeDocTypeSystemIdentifierTS();
    static TokeniserState DoctypeSystemIdentifier_doubleQuoted = new DocTypeSystemIdentifierDoubleQuotedTS();
    static TokeniserState DoctypeSystemIdentifier_singleQuoted = new DocTypeSystemIdentifierSingleQuotedTS();
    static TokeniserState AfterDoctypeSystemIdentifier = new AfterDocTypeSystemIdentifierTS();
    static TokeniserState BogusDoctype = new BogusDocTypeTS();
    static TokeniserState CdataSection = new CDataSectionTS();
    static final char nullChar = '\u0000';
    static final char[] attributeNameCharsSorted = new char[]{'\u0000', '\t', '\n', '\f', '\r', ' ', '\"', '\'', '/', '<', '=', '>'};
    static final char[] attributeValueUnquoted = new char[]{'\u0000', '\t', '\n', '\f', '\r', ' ', '\"', '&', '\'', '<', '=', '>', '`'};
    private static final char replacementChar = '\ufffd';
    private static final String replacementStr = String.valueOf('\ufffd');
    private static final char eof = '\uffff';

    TokeniserState() {
    }

    abstract void read(Tokeniser var1, CharacterReader var2);

    private static void handleDataEndTag(Tokeniser t, CharacterReader r, TokeniserState elseTransition) {
        if (r.matchesLetter()) {
            String name = r.consumeLetterSequence();
            t.tagPending.appendTagName(name);
            t.dataBuffer.append(name);
            return;
        }
        boolean needsExitTransition = false;
        if (t.isAppropriateEndTagToken() && !r.isEmpty()) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(BeforeAttributeName);
                    break;
                }
                case '/': {
                    t.transition(SelfClosingStartTag);
                    break;
                }
                case '>': {
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.dataBuffer.append(c);
                    needsExitTransition = true;
                    break;
                }
            }
        } else {
            needsExitTransition = true;
        }
        if (needsExitTransition) {
            t.emit("</");
            t.emit(t.dataBuffer);
            t.transition(elseTransition);
        }
    }

    private static void readRawData(Tokeniser t, CharacterReader r, TokeniserState current, TokeniserState advance) {
        switch (r.current()) {
            case '<': {
                t.advanceTransition(advance);
                break;
            }
            case '\u0000': {
                t.error(current);
                r.advance();
                t.emit('\ufffd');
                break;
            }
            case '\uffff': {
                t.emit(new Token.EOF());
                break;
            }
            default: {
                String data = r.consumeRawData();
                t.emit(data);
            }
        }
    }

    private static void readCharRef(Tokeniser t, TokeniserState advance) {
        int[] c = t.consumeCharacterReference(null, false);
        if (c == null) {
            t.emit('&');
        } else {
            t.emit(c);
        }
        t.transition(advance);
    }

    private static void readEndTag(Tokeniser t, CharacterReader r, TokeniserState a, TokeniserState b) {
        if (r.matchesLetter()) {
            t.createTagPending(false);
            t.transition(a);
        } else {
            t.emit("</");
            t.transition(b);
        }
    }

    private static void handleDataDoubleEscapeTag(Tokeniser t, CharacterReader r, TokeniserState primary, TokeniserState fallback) {
        if (r.matchesLetter()) {
            String name = r.consumeLetterSequence();
            t.dataBuffer.append(name);
            t.emit(name);
            return;
        }
        char c = r.consume();
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '/': 
            case '>': {
                if (t.dataBuffer.toString().equals("script")) {
                    t.transition(primary);
                } else {
                    t.transition(fallback);
                }
                t.emit(c);
                break;
            }
            default: {
                r.unconsume();
                t.transition(fallback);
            }
        }
    }

    private static final class CDataSectionTS
    extends TokeniserState {
        private CDataSectionTS() {
        }

        public String toString() {
            return "CdataSection";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            String data = r.consumeTo("]]>");
            t.dataBuffer.append(data);
            if (r.matchConsume("]]>") || r.isEmpty()) {
                t.emit(new Token.CData(t.dataBuffer.toString()));
                t.transition(Data);
            }
        }
    }

    private static final class BogusDocTypeTS
    extends TokeniserState {
        private BogusDocTypeTS() {
        }

        public String toString() {
            return "BogusDoctype";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '>': {
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
            }
        }
    }

    private static final class AfterDocTypeSystemIdentifierTS
    extends TokeniserState {
        private AfterDocTypeSystemIdentifierTS() {
        }

        public String toString() {
            return "AfterDoctypeSystemIdentifier";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '>': {
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.error(this);
                    t.transition(BogusDoctype);
                }
            }
        }
    }

    private static final class DocTypeSystemIdentifierSingleQuotedTS
    extends TokeniserState {
        private DocTypeSystemIdentifierSingleQuotedTS() {
        }

        public String toString() {
            return "DoctypeSystemIdentifier_singleQuoted";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\'': {
                    t.transition(AfterDoctypeSystemIdentifier);
                    break;
                }
                case '>': {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.doctypePending.systemIdentifier.append('\ufffd');
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.doctypePending.systemIdentifier.append(c);
                }
            }
        }
    }

    private static final class DocTypeSystemIdentifierDoubleQuotedTS
    extends TokeniserState {
        private DocTypeSystemIdentifierDoubleQuotedTS() {
        }

        public String toString() {
            return "DoctypeSystemIdentifier_doubleQuoted";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.doctypePending.systemIdentifier.append('\ufffd');
                    break;
                }
                case '\"': {
                    t.transition(AfterDoctypeSystemIdentifier);
                    break;
                }
                case '>': {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.doctypePending.systemIdentifier.append(c);
                }
            }
        }
    }

    private static final class BeforeDocTypeSystemIdentifierTS
    extends TokeniserState {
        private BeforeDocTypeSystemIdentifierTS() {
        }

        public String toString() {
            return "BeforeDoctypeSystemIdentifier";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\"': {
                    t.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    t.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '>': {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.transition(BogusDoctype);
                }
            }
        }
    }

    private static final class AfterDocTypeSystemKeywordTS
    extends TokeniserState {
        private AfterDocTypeSystemKeywordTS() {
        }

        public String toString() {
            return "AfterDoctypeSystemKeyword";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '>': {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(BeforeDoctypeSystemIdentifier);
                    break;
                }
                case '\"': {
                    t.error(this);
                    t.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\'': {
                    t.error(this);
                    t.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                default: {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                }
            }
        }
    }

    private static final class BetweenDocTypePublicAndSystemIdentifiersTS
    extends TokeniserState {
        private BetweenDocTypePublicAndSystemIdentifiersTS() {
        }

        public String toString() {
            return "BetweenDoctypePublicAndSystemIdentifiers";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '>': {
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\"': {
                    t.error(this);
                    t.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    t.error(this);
                    t.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.transition(BogusDoctype);
                }
            }
        }
    }

    private static final class AfterDocTypePublicIdentifierTS
    extends TokeniserState {
        private AfterDocTypePublicIdentifierTS() {
        }

        public String toString() {
            return "AfterDoctypePublicIdentifier";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(BetweenDoctypePublicAndSystemIdentifiers);
                    break;
                }
                case '\"': {
                    t.error(this);
                    t.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '>': {
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\'': {
                    t.error(this);
                    t.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                default: {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.transition(BogusDoctype);
                }
            }
        }
    }

    private static final class DocTypePublicIdentifierSingleQuotedTS
    extends TokeniserState {
        private DocTypePublicIdentifierSingleQuotedTS() {
        }

        public String toString() {
            return "DoctypePublicIdentifier_singleQuoted";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\'': {
                    t.transition(AfterDoctypePublicIdentifier);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.doctypePending.publicIdentifier.append('\ufffd');
                    break;
                }
                case '>': {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.doctypePending.publicIdentifier.append(c);
                }
            }
        }
    }

    private static final class DocTypePublicIdentifierDoubleQuotedTS
    extends TokeniserState {
        private DocTypePublicIdentifierDoubleQuotedTS() {
        }

        public String toString() {
            return "DoctypePublicIdentifier_doubleQuoted";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\"': {
                    t.transition(AfterDoctypePublicIdentifier);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '>': {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.doctypePending.publicIdentifier.append('\ufffd');
                    break;
                }
                default: {
                    t.doctypePending.publicIdentifier.append(c);
                }
            }
        }
    }

    private static final class BeforeDocTypePublicIdentifierTS
    extends TokeniserState {
        private BeforeDocTypePublicIdentifierTS() {
        }

        public String toString() {
            return "BeforeDoctypePublicIdentifier";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\"': {
                    t.transition(DoctypePublicIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    t.transition(DoctypePublicIdentifier_singleQuoted);
                    break;
                }
                case '>': {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.transition(BogusDoctype);
                }
            }
        }
    }

    private static final class AfterDocTypePublicKeywordTS
    extends TokeniserState {
        private AfterDocTypePublicKeywordTS() {
        }

        public String toString() {
            return "AfterDoctypePublicKeyword";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(BeforeDoctypePublicIdentifier);
                    break;
                }
                case '\"': {
                    t.error(this);
                    t.transition(DoctypePublicIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    t.error(this);
                    t.transition(DoctypePublicIdentifier_singleQuoted);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '>': {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.error(this);
                    t.doctypePending.forceQuirks = true;
                    t.transition(BogusDoctype);
                }
            }
        }
    }

    private static final class AfterDocTypeNameTS
    extends TokeniserState {
        private AfterDocTypeNameTS() {
        }

        public String toString() {
            return "AfterDoctypeName";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.isEmpty()) {
                t.eofError(this);
                t.doctypePending.forceQuirks = true;
                t.emitDoctypePending();
                t.transition(Data);
                return;
            }
            if (r.matchesAny('\t', '\n', '\r', '\f', ' ')) {
                r.advance();
            } else if (r.matches('>')) {
                t.emitDoctypePending();
                t.advanceTransition(Data);
            } else if (r.matchConsumeIgnoreCase("PUBLIC")) {
                t.doctypePending.pubSysKey = "PUBLIC";
                t.transition(AfterDoctypePublicKeyword);
            } else if (r.matchConsumeIgnoreCase("SYSTEM")) {
                t.doctypePending.pubSysKey = "SYSTEM";
                t.transition(AfterDoctypeSystemKeyword);
            } else {
                t.error(this);
                t.doctypePending.forceQuirks = true;
                t.advanceTransition(BogusDoctype);
            }
        }
    }

    private static final class DocTypeNameTS
    extends TokeniserState {
        private DocTypeNameTS() {
        }

        public String toString() {
            return "DoctypeName";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matchesLetter()) {
                String name = r.consumeLetterSequence();
                t.doctypePending.name.append(name);
                return;
            }
            char c = r.consume();
            switch (c) {
                case '>': {
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(AfterDoctypeName);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.doctypePending.name.append('\ufffd');
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.doctypePending.name.append(c);
                }
            }
        }
    }

    private static final class BeforeDocTypeNameTS
    extends TokeniserState {
        private BeforeDocTypeNameTS() {
        }

        public String toString() {
            return "BeforeDoctypeName";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matchesLetter()) {
                t.createDoctypePending();
                t.transition(DoctypeName);
                return;
            }
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.createDoctypePending();
                    t.doctypePending.name.append('\ufffd');
                    t.transition(DoctypeName);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.createDoctypePending();
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.createDoctypePending();
                    t.doctypePending.name.append(c);
                    t.transition(DoctypeName);
                }
            }
        }
    }

    private static final class DocTypeTS
    extends TokeniserState {
        private DocTypeTS() {
        }

        public String toString() {
            return "Doctype";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(BeforeDoctypeName);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                }
                case '>': {
                    t.error(this);
                    t.createDoctypePending();
                    t.doctypePending.forceQuirks = true;
                    t.emitDoctypePending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.error(this);
                    t.transition(BeforeDoctypeName);
                }
            }
        }
    }

    private static final class CommentEndBangTS
    extends TokeniserState {
        private CommentEndBangTS() {
        }

        public String toString() {
            return "CommentEndBang";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '-': {
                    t.commentPending.append("--!");
                    t.transition(CommentEndDash);
                    break;
                }
                case '>': {
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.commentPending.append("--!").append('\ufffd');
                    t.transition(Comment);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.commentPending.append("--!").append(c);
                    t.transition(Comment);
                }
            }
        }
    }

    private static final class CommentEndTS
    extends TokeniserState {
        private CommentEndTS() {
        }

        public String toString() {
            return "CommentEnd";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '>': {
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.commentPending.append("--").append('\ufffd');
                    t.transition(Comment);
                    break;
                }
                case '!': {
                    t.error(this);
                    t.transition(CommentEndBang);
                    break;
                }
                case '-': {
                    t.error(this);
                    t.commentPending.append('-');
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.error(this);
                    t.commentPending.append("--").append(c);
                    t.transition(Comment);
                }
            }
        }
    }

    private static final class CommentEndDashTS
    extends TokeniserState {
        private CommentEndDashTS() {
        }

        public String toString() {
            return "CommentEndDash";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '-': {
                    t.transition(CommentEnd);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.commentPending.append('-').append('\ufffd');
                    t.transition(Comment);
                    break;
                }
                default: {
                    t.commentPending.append('-').append(c);
                    t.transition(Comment);
                }
            }
        }
    }

    private static final class CommentTS
    extends TokeniserState {
        private CommentTS() {
        }

        public String toString() {
            return "Comment";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.current();
            switch (c) {
                case '-': {
                    t.advanceTransition(CommentEndDash);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    r.advance();
                    t.commentPending.append('\ufffd');
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.commentPending.append(r.consumeToAny('-', '\u0000'));
                }
            }
        }
    }

    private static final class CommentStartDashTS
    extends TokeniserState {
        private CommentStartDashTS() {
        }

        public String toString() {
            return "CommentStartDash";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '-': {
                    t.transition(CommentStartDash);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.commentPending.append('\ufffd');
                    t.transition(Comment);
                    break;
                }
                case '>': {
                    t.error(this);
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                default: {
                    t.commentPending.append(c);
                    t.transition(Comment);
                }
            }
        }
    }

    private static final class CommentStartTS
    extends TokeniserState {
        private CommentStartTS() {
        }

        public String toString() {
            return "CommentStart";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\uffff': {
                    t.eofError(this);
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                case '-': {
                    t.transition(CommentStartDash);
                    break;
                }
                case '>': {
                    t.error(this);
                    t.emitCommentPending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.commentPending.append('\ufffd');
                    t.transition(Comment);
                    break;
                }
                default: {
                    r.unconsume();
                    t.transition(Comment);
                }
            }
        }
    }

    private static final class MarkupDeclarationOpenTS
    extends TokeniserState {
        private MarkupDeclarationOpenTS() {
        }

        public String toString() {
            return "MarkupDeclarationOpen";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matchConsume("--")) {
                t.createCommentPending();
                t.transition(CommentStart);
            } else if (r.matchConsumeIgnoreCase("DOCTYPE")) {
                t.transition(Doctype);
            } else if (r.matchConsume("[CDATA[")) {
                t.createTempBuffer();
                t.transition(CdataSection);
            } else {
                t.error(this);
                t.createBogusCommentPending();
                t.advanceTransition(BogusComment);
            }
        }
    }

    private static final class BogusCommentTS
    extends TokeniserState {
        private BogusCommentTS() {
        }

        public String toString() {
            return "BogusComment";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            r.unconsume();
            t.commentPending.append(r.consumeTo('>'));
            char next = r.consume();
            if (next == '>' || next == '\uffff') {
                t.emitCommentPending();
                t.transition(Data);
            }
        }
    }

    private static final class SelfClosingStartTagTS
    extends TokeniserState {
        private SelfClosingStartTagTS() {
        }

        public String toString() {
            return "SelfClosingStartTag";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '>': {
                    t.tagPending.selfClosing = true;
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                default: {
                    r.unconsume();
                    t.error(this);
                    t.transition(BeforeAttributeName);
                }
            }
        }
    }

    private static final class AfterAttributeValueQuotedTS
    extends TokeniserState {
        private AfterAttributeValueQuotedTS() {
        }

        public String toString() {
            return "AfterAttributeValue_quoted";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(BeforeAttributeName);
                    break;
                }
                case '/': {
                    t.transition(SelfClosingStartTag);
                    break;
                }
                case '>': {
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                default: {
                    r.unconsume();
                    t.error(this);
                    t.transition(BeforeAttributeName);
                }
            }
        }
    }

    private static final class AttributeValueUnquotedTS
    extends TokeniserState {
        private AttributeValueUnquotedTS() {
        }

        public String toString() {
            return "AttributeValue_unquoted";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            String value = r.consumeToAnySorted(attributeValueUnquoted);
            if (value.length() > 0) {
                t.tagPending.appendAttributeValue(value);
            }
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(BeforeAttributeName);
                    break;
                }
                case '&': {
                    int[] ref = t.consumeCharacterReference(Character.valueOf('>'), true);
                    if (ref != null) {
                        t.tagPending.appendAttributeValue(ref);
                        break;
                    }
                    t.tagPending.appendAttributeValue('&');
                    break;
                }
                case '>': {
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.tagPending.appendAttributeValue('\ufffd');
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '<': 
                case '=': 
                case '`': {
                    t.error(this);
                    t.tagPending.appendAttributeValue(c);
                    break;
                }
                default: {
                    t.tagPending.appendAttributeValue(c);
                }
            }
        }
    }

    private static final class AttributeValueSingleQuotedTS
    extends TokeniserState {
        private AttributeValueSingleQuotedTS() {
        }

        public String toString() {
            return "AttributeValue_singleQuoted";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            String value = r.consumeAttributeQuoted(true);
            if (value.length() > 0) {
                t.tagPending.appendAttributeValue(value);
            } else {
                t.tagPending.setEmptyAttributeValue();
            }
            char c = r.consume();
            switch (c) {
                case '\'': {
                    t.transition(AfterAttributeValue_quoted);
                    break;
                }
                case '&': {
                    int[] ref = t.consumeCharacterReference(Character.valueOf('\''), true);
                    if (ref != null) {
                        t.tagPending.appendAttributeValue(ref);
                        break;
                    }
                    t.tagPending.appendAttributeValue('&');
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.tagPending.appendAttributeValue('\ufffd');
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                default: {
                    t.tagPending.appendAttributeValue(c);
                }
            }
        }
    }

    private static final class AttributeValueDoubleQuotedTS
    extends TokeniserState {
        private AttributeValueDoubleQuotedTS() {
        }

        public String toString() {
            return "AttributeValue_doubleQuoted";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            String value = r.consumeAttributeQuoted(false);
            if (value.length() > 0) {
                t.tagPending.appendAttributeValue(value);
            } else {
                t.tagPending.setEmptyAttributeValue();
            }
            char c = r.consume();
            switch (c) {
                case '&': {
                    int[] ref = t.consumeCharacterReference(Character.valueOf('\"'), true);
                    if (ref != null) {
                        t.tagPending.appendAttributeValue(ref);
                        break;
                    }
                    t.tagPending.appendAttributeValue('&');
                    break;
                }
                case '\"': {
                    t.transition(AfterAttributeValue_quoted);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.tagPending.appendAttributeValue('\ufffd');
                    break;
                }
                default: {
                    t.tagPending.appendAttributeValue(c);
                }
            }
        }
    }

    private static final class BeforeAttributeValueTS
    extends TokeniserState {
        private BeforeAttributeValueTS() {
        }

        public String toString() {
            return "BeforeAttributeValue";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\"': {
                    t.transition(AttributeValue_doubleQuoted);
                    break;
                }
                case '&': {
                    r.unconsume();
                    t.transition(AttributeValue_unquoted);
                    break;
                }
                case '\'': {
                    t.transition(AttributeValue_singleQuoted);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.tagPending.appendAttributeValue('\ufffd');
                    t.transition(AttributeValue_unquoted);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '>': {
                    t.error(this);
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '<': 
                case '=': 
                case '`': {
                    t.error(this);
                    t.tagPending.appendAttributeValue(c);
                    t.transition(AttributeValue_unquoted);
                    break;
                }
                default: {
                    r.unconsume();
                    t.transition(AttributeValue_unquoted);
                }
            }
        }
    }

    private static final class AfterAttributeNameTS
    extends TokeniserState {
        private AfterAttributeNameTS() {
        }

        public String toString() {
            return "AfterAttributeName";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '/': {
                    t.transition(SelfClosingStartTag);
                    break;
                }
                case '=': {
                    t.transition(BeforeAttributeValue);
                    break;
                }
                case '>': {
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.tagPending.appendAttributeName('\ufffd');
                    t.transition(AttributeName);
                    break;
                }
                case '\"': 
                case '\'': 
                case '<': {
                    t.error(this);
                    t.tagPending.newAttribute();
                    t.tagPending.appendAttributeName(c);
                    t.transition(AttributeName);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                default: {
                    t.tagPending.newAttribute();
                    r.unconsume();
                    t.transition(AttributeName);
                }
            }
        }
    }

    private static final class AttributeNameTS
    extends TokeniserState {
        private AttributeNameTS() {
        }

        public String toString() {
            return "AttributeName";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            String name = r.consumeToAnySorted(attributeNameCharsSorted);
            t.tagPending.appendAttributeName(name);
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(AfterAttributeName);
                    break;
                }
                case '/': {
                    t.transition(SelfClosingStartTag);
                    break;
                }
                case '=': {
                    t.transition(BeforeAttributeValue);
                    break;
                }
                case '>': {
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.tagPending.appendAttributeName('\ufffd');
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '<': {
                    t.error(this);
                    t.tagPending.appendAttributeName(c);
                    break;
                }
                default: {
                    t.tagPending.appendAttributeName(c);
                }
            }
        }
    }

    private static final class BeforeAttributeNameTS
    extends TokeniserState {
        private BeforeAttributeNameTS() {
        }

        public String toString() {
            return "BeforeAttributeName";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '/': {
                    t.transition(SelfClosingStartTag);
                    break;
                }
                case '<': {
                    r.unconsume();
                    t.error(this);
                }
                case '>': {
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    r.unconsume();
                    t.error(this);
                    t.tagPending.newAttribute();
                    t.transition(AttributeName);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '=': {
                    t.error(this);
                    t.tagPending.newAttribute();
                    t.tagPending.appendAttributeName(c);
                    t.transition(AttributeName);
                    break;
                }
                default: {
                    t.tagPending.newAttribute();
                    r.unconsume();
                    t.transition(AttributeName);
                }
            }
        }
    }

    private static final class ScriptDataDoubleEscapeEndTS
    extends TokeniserState {
        private ScriptDataDoubleEscapeEndTS() {
        }

        public String toString() {
            return "ScriptDataDoubleEscapeEnd";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.handleDataDoubleEscapeTag(t, r, ScriptDataDoubleEscapeEndTS.ScriptDataEscaped, ScriptDataDoubleEscapeEndTS.ScriptDataDoubleEscaped);
        }
    }

    private static final class ScriptDataDoubleEscapedLessThanSignTS
    extends TokeniserState {
        private ScriptDataDoubleEscapedLessThanSignTS() {
        }

        public String toString() {
            return "ScriptDataDoubleEscapedLessthanSign";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matches('/')) {
                t.emit('/');
                t.createTempBuffer();
                t.advanceTransition(ScriptDataDoubleEscapeEnd);
            } else {
                t.transition(ScriptDataDoubleEscaped);
            }
        }
    }

    private static final class ScriptDataDoubleEscapedDashDashTS
    extends TokeniserState {
        private ScriptDataDoubleEscapedDashDashTS() {
        }

        public String toString() {
            return "ScriptDataDoubleEscapedDashDash";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '-': {
                    t.emit(c);
                    break;
                }
                case '<': {
                    t.emit(c);
                    t.transition(ScriptDataDoubleEscapedLessthanSign);
                    break;
                }
                case '>': {
                    t.emit(c);
                    t.transition(ScriptData);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.emit('\ufffd');
                    t.transition(ScriptDataDoubleEscaped);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                default: {
                    t.emit(c);
                    t.transition(ScriptDataDoubleEscaped);
                }
            }
        }
    }

    private static final class ScriptDataDoubleEscapedDashTS
    extends TokeniserState {
        private ScriptDataDoubleEscapedDashTS() {
        }

        public String toString() {
            return "ScriptDataDoubleEscapedDash";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.consume();
            switch (c) {
                case '-': {
                    t.emit(c);
                    t.transition(ScriptDataDoubleEscapedDashDash);
                    break;
                }
                case '<': {
                    t.emit(c);
                    t.transition(ScriptDataDoubleEscapedLessthanSign);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.emit('\ufffd');
                    t.transition(ScriptDataDoubleEscaped);
                    break;
                }
                default: {
                    t.emit(c);
                    t.transition(ScriptDataDoubleEscaped);
                }
            }
        }
    }

    private static final class ScriptDataDoubleEscapedTS
    extends TokeniserState {
        private ScriptDataDoubleEscapedTS() {
        }

        public String toString() {
            return "ScriptDataDoubleEscaped";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            char c = r.current();
            switch (c) {
                case '-': {
                    t.emit(c);
                    t.advanceTransition(ScriptDataDoubleEscapedDash);
                    break;
                }
                case '<': {
                    t.emit(c);
                    t.advanceTransition(ScriptDataDoubleEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    r.advance();
                    t.emit('\ufffd');
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                default: {
                    String data = r.consumeToAny('-', '<', '\u0000');
                    t.emit(data);
                }
            }
        }
    }

    private static final class ScriptDataDoubleEscapeStartTS
    extends TokeniserState {
        private ScriptDataDoubleEscapeStartTS() {
        }

        public String toString() {
            return "ScriptDataDoubleEscapeStart";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.handleDataDoubleEscapeTag(t, r, ScriptDataDoubleEscapeStartTS.ScriptDataDoubleEscaped, ScriptDataDoubleEscapeStartTS.ScriptDataEscaped);
        }
    }

    private static final class ScriptDataEscapedEndTagNameTS
    extends TokeniserState {
        private ScriptDataEscapedEndTagNameTS() {
        }

        public String toString() {
            return "ScriptDataEscapedEndTagName";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.handleDataEndTag(t, r, ScriptDataEscapedEndTagNameTS.ScriptDataEscaped);
        }
    }

    private static final class ScriptDataEscapedEndTagOpenTS
    extends TokeniserState {
        private ScriptDataEscapedEndTagOpenTS() {
        }

        public String toString() {
            return "ScriptDataEscapedEndTagOpen";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matchesLetter()) {
                t.createTagPending(false);
                t.tagPending.appendTagName(r.current());
                t.dataBuffer.append(r.current());
                t.advanceTransition(ScriptDataEscapedEndTagName);
            } else {
                t.emit("</");
                t.transition(ScriptDataEscaped);
            }
        }
    }

    private static final class ScriptDataEscapedLessThanSignTS
    extends TokeniserState {
        private ScriptDataEscapedLessThanSignTS() {
        }

        public String toString() {
            return "ScriptDataEscapedLessthanSign";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matchesLetter()) {
                t.createTempBuffer();
                t.dataBuffer.append(r.current());
                t.emit("<");
                t.emit(r.current());
                t.advanceTransition(ScriptDataDoubleEscapeStart);
            } else if (r.matches('/')) {
                t.createTempBuffer();
                t.advanceTransition(ScriptDataEscapedEndTagOpen);
            } else {
                t.emit('<');
                t.transition(ScriptDataEscaped);
            }
        }
    }

    private static final class ScriptDataEscapedDashDashTS
    extends TokeniserState {
        private ScriptDataEscapedDashDashTS() {
        }

        public String toString() {
            return "ScriptDataEscapedDashDash";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.isEmpty()) {
                t.eofError(this);
                t.transition(Data);
                return;
            }
            char c = r.consume();
            switch (c) {
                case '-': {
                    t.emit(c);
                    break;
                }
                case '<': {
                    t.transition(ScriptDataEscapedLessthanSign);
                    break;
                }
                case '>': {
                    t.emit(c);
                    t.transition(ScriptData);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.emit('\ufffd');
                    t.transition(ScriptDataEscaped);
                    break;
                }
                default: {
                    t.emit(c);
                    t.transition(ScriptDataEscaped);
                }
            }
        }
    }

    private static final class ScriptDataEscapedDashTS
    extends TokeniserState {
        private ScriptDataEscapedDashTS() {
        }

        public String toString() {
            return "ScriptDataEscapedDash";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.isEmpty()) {
                t.eofError(this);
                t.transition(Data);
                return;
            }
            char c = r.consume();
            switch (c) {
                case '-': {
                    t.emit(c);
                    t.transition(ScriptDataEscapedDashDash);
                    break;
                }
                case '<': {
                    t.transition(ScriptDataEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.emit('\ufffd');
                    t.transition(ScriptDataEscaped);
                    break;
                }
                default: {
                    t.emit(c);
                    t.transition(ScriptDataEscaped);
                }
            }
        }
    }

    private static final class ScriptDataEscapedTS
    extends TokeniserState {
        private ScriptDataEscapedTS() {
        }

        public String toString() {
            return "ScriptDataEscaped";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.isEmpty()) {
                t.eofError(this);
                t.transition(Data);
                return;
            }
            switch (r.current()) {
                case '-': {
                    t.emit('-');
                    t.advanceTransition(ScriptDataEscapedDash);
                    break;
                }
                case '<': {
                    t.advanceTransition(ScriptDataEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    r.advance();
                    t.emit('\ufffd');
                    break;
                }
                default: {
                    String data = r.consumeToAny('-', '<', '\u0000');
                    t.emit(data);
                }
            }
        }
    }

    private static final class ScriptDataEscapeStartDashTS
    extends TokeniserState {
        private ScriptDataEscapeStartDashTS() {
        }

        public String toString() {
            return "ScriptDataEscapeStartDash";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matches('-')) {
                t.emit('-');
                t.advanceTransition(ScriptDataEscapedDashDash);
            } else {
                t.transition(ScriptData);
            }
        }
    }

    private static final class ScriptDataEscapeStartTS
    extends TokeniserState {
        private ScriptDataEscapeStartTS() {
        }

        public String toString() {
            return "ScriptDataEscapeStart";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matches('-')) {
                t.emit('-');
                t.advanceTransition(ScriptDataEscapeStartDash);
            } else {
                t.transition(ScriptData);
            }
        }
    }

    private static final class ScriptDataEndTagNameTS
    extends TokeniserState {
        private ScriptDataEndTagNameTS() {
        }

        public String toString() {
            return "ScriptDataEndTagName";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.handleDataEndTag(t, r, ScriptDataEndTagNameTS.ScriptData);
        }
    }

    private static final class ScriptDataEndTagOpenTS
    extends TokeniserState {
        private ScriptDataEndTagOpenTS() {
        }

        public String toString() {
            return "ScriptDataEndTagOpen";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.readEndTag(t, r, ScriptDataEndTagOpenTS.ScriptDataEndTagName, ScriptDataEndTagOpenTS.ScriptData);
        }
    }

    private static final class ScriptDataLessThanSignTS
    extends TokeniserState {
        private ScriptDataLessThanSignTS() {
        }

        public String toString() {
            return "ScriptDataLessthanSign";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            switch (r.consume()) {
                case '/': {
                    t.createTempBuffer();
                    t.transition(ScriptDataEndTagOpen);
                    break;
                }
                case '!': {
                    t.emit("<!");
                    t.transition(ScriptDataEscapeStart);
                    break;
                }
                case '\uffff': {
                    t.emit("<");
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                default: {
                    t.emit("<");
                    r.unconsume();
                    t.transition(ScriptData);
                }
            }
        }
    }

    private static final class RawTextEndTagNameTS
    extends TokeniserState {
        private RawTextEndTagNameTS() {
        }

        public String toString() {
            return "RawtextEndTagName";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.handleDataEndTag(t, r, RawTextEndTagNameTS.Rawtext);
        }
    }

    private static final class RawTextEndTagOpenTS
    extends TokeniserState {
        private RawTextEndTagOpenTS() {
        }

        public String toString() {
            return "RawtextEndTagOpen";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.readEndTag(t, r, RawTextEndTagOpenTS.RawtextEndTagName, RawTextEndTagOpenTS.Rawtext);
        }
    }

    private static final class RawTextLessThanSignTS
    extends TokeniserState {
        private RawTextLessThanSignTS() {
        }

        public String toString() {
            return "RawtextLessthanSign";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matches('/')) {
                t.createTempBuffer();
                t.advanceTransition(RawtextEndTagOpen);
            } else {
                t.emit('<');
                t.transition(Rawtext);
            }
        }
    }

    private static final class RcDataEndTagNameTS
    extends TokeniserState {
        private RcDataEndTagNameTS() {
        }

        public String toString() {
            return "RCDATAEndTagName";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matchesLetter()) {
                String name = r.consumeLetterSequence();
                t.tagPending.appendTagName(name);
                t.dataBuffer.append(name);
                return;
            }
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (t.isAppropriateEndTagToken()) {
                        t.transition(BeforeAttributeName);
                        break;
                    }
                    this.anythingElse(t, r);
                    break;
                }
                case '/': {
                    if (t.isAppropriateEndTagToken()) {
                        t.transition(SelfClosingStartTag);
                        break;
                    }
                    this.anythingElse(t, r);
                    break;
                }
                case '>': {
                    if (t.isAppropriateEndTagToken()) {
                        t.emitTagPending();
                        t.transition(Data);
                        break;
                    }
                    this.anythingElse(t, r);
                    break;
                }
                default: {
                    this.anythingElse(t, r);
                }
            }
        }

        private void anythingElse(Tokeniser t, CharacterReader r) {
            t.emit("</");
            t.emit(t.dataBuffer);
            r.unconsume();
            t.transition(Rcdata);
        }
    }

    private static final class RcDataEndTagOpenTS
    extends TokeniserState {
        private RcDataEndTagOpenTS() {
        }

        public String toString() {
            return "RCDATAEndTagOpen";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matchesLetter()) {
                t.createTagPending(false);
                t.tagPending.appendTagName(r.current());
                t.dataBuffer.append(r.current());
                t.advanceTransition(RCDATAEndTagName);
            } else {
                t.emit("</");
                t.transition(Rcdata);
            }
        }
    }

    private static final class RcDataLessThanSignTS
    extends TokeniserState {
        private RcDataLessThanSignTS() {
        }

        public String toString() {
            return "RcdataLessthanSign";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.matches('/')) {
                t.createTempBuffer();
                t.advanceTransition(RCDATAEndTagOpen);
            } else if (r.matchesLetter() && t.appropriateEndTagName() != null && !r.containsIgnoreCase("</" + t.appropriateEndTagName())) {
                t.tagPending = t.createTagPending(false).name(t.appropriateEndTagName());
                t.emitTagPending();
                t.transition(TagOpen);
            } else {
                t.emit("<");
                t.transition(Rcdata);
            }
        }
    }

    private static final class TagNameTS
    extends TokeniserState {
        private TagNameTS() {
        }

        public String toString() {
            return "TagName";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            String tagName = r.consumeTagName();
            t.tagPending.appendTagName(tagName);
            char c = r.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    t.transition(BeforeAttributeName);
                    break;
                }
                case '/': {
                    t.transition(SelfClosingStartTag);
                    break;
                }
                case '<': {
                    r.unconsume();
                    t.error(this);
                }
                case '>': {
                    t.emitTagPending();
                    t.transition(Data);
                    break;
                }
                case '\u0000': {
                    t.tagPending.appendTagName(replacementStr);
                    break;
                }
                case '\uffff': {
                    t.eofError(this);
                    t.transition(Data);
                    break;
                }
                default: {
                    t.tagPending.appendTagName(c);
                }
            }
        }
    }

    private static final class EndTagOpenTS
    extends TokeniserState {
        private EndTagOpenTS() {
        }

        public String toString() {
            return "EndTagOpen";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            if (r.isEmpty()) {
                t.eofError(this);
                t.emit("</");
                t.transition(Data);
            } else if (r.matchesLetter()) {
                t.createTagPending(false);
                t.transition(TagName);
            } else if (r.matches('>')) {
                t.error(this);
                t.advanceTransition(Data);
            } else {
                t.error(this);
                t.createBogusCommentPending();
                t.advanceTransition(BogusComment);
            }
        }
    }

    private static final class TagOpenTS
    extends TokeniserState {
        private TagOpenTS() {
        }

        public String toString() {
            return "TagOpen";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            switch (r.current()) {
                case '!': {
                    t.advanceTransition(MarkupDeclarationOpen);
                    break;
                }
                case '/': {
                    t.advanceTransition(EndTagOpen);
                    break;
                }
                case '?': {
                    t.createBogusCommentPending();
                    t.advanceTransition(BogusComment);
                    break;
                }
                default: {
                    if (r.matchesLetter()) {
                        t.createTagPending(true);
                        t.transition(TagName);
                        break;
                    }
                    t.error(this);
                    t.emit('<');
                    t.transition(Data);
                }
            }
        }
    }

    private static final class PlainTextTS
    extends TokeniserState {
        private PlainTextTS() {
        }

        public String toString() {
            return "PLAINTEXT";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            switch (r.current()) {
                case '\u0000': {
                    t.error(this);
                    r.advance();
                    t.emit('\ufffd');
                    break;
                }
                case '\uffff': {
                    t.emit(new Token.EOF());
                    break;
                }
                default: {
                    String data = r.consumeTo('\u0000');
                    t.emit(data);
                }
            }
        }
    }

    private static final class ScriptDataTS
    extends TokeniserState {
        private ScriptDataTS() {
        }

        public String toString() {
            return "ScriptData";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.readRawData(t, r, (TokeniserState)this, ScriptDataTS.ScriptDataLessthanSign);
        }
    }

    private static final class RawTextTS
    extends TokeniserState {
        private RawTextTS() {
        }

        public String toString() {
            return "Rawtext";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.readRawData(t, r, (TokeniserState)this, RawTextTS.RawtextLessthanSign);
        }
    }

    private static final class CharacterReferenceInRcdataTS
    extends TokeniserState {
        private CharacterReferenceInRcdataTS() {
        }

        public String toString() {
            return "CharacterReferenceInRcdata";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.readCharRef(t, CharacterReferenceInRcdataTS.Rcdata);
        }
    }

    private static final class RcDataTS
    extends TokeniserState {
        private RcDataTS() {
        }

        public String toString() {
            return "Rcdata";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            switch (r.current()) {
                case '&': {
                    t.advanceTransition(CharacterReferenceInRcdata);
                    break;
                }
                case '<': {
                    t.advanceTransition(RcdataLessthanSign);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    r.advance();
                    t.emit('\ufffd');
                    break;
                }
                case '\uffff': {
                    t.emit(new Token.EOF());
                    break;
                }
                default: {
                    String data = r.consumeData();
                    t.emit(data);
                }
            }
        }
    }

    private static final class CharacterReferenceInDataTS
    extends TokeniserState {
        private CharacterReferenceInDataTS() {
        }

        public String toString() {
            return "CharacterReferenceInData";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            TokeniserState.readCharRef(t, CharacterReferenceInDataTS.Data);
        }
    }

    private static final class DataTS
    extends TokeniserState {
        private DataTS() {
        }

        public String toString() {
            return "Data";
        }

        @Override
        void read(Tokeniser t, CharacterReader r) {
            switch (r.current()) {
                case '&': {
                    t.advanceTransition(CharacterReferenceInData);
                    break;
                }
                case '<': {
                    t.advanceTransition(TagOpen);
                    break;
                }
                case '\u0000': {
                    t.error(this);
                    t.emit(r.consume());
                    break;
                }
                case '\uffff': {
                    t.emit(new Token.EOF());
                    break;
                }
                default: {
                    String data = r.consumeData();
                    t.emit(data);
                }
            }
        }
    }
}

