/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.validate.impl;

import com.itextpdf.styledxmlparser.css.CommonCssConstants;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.validate.ICssDeclarationValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.ArrayDataTypeValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssBackgroundValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssBlendModeValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssColorValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssEnumValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssLengthValueValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssNumberValueValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssPercentageValueValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssQuotesValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssTransformValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.declaration.MultiTypeDeclarationValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.declaration.SingleTypeDeclarationValidator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CssDefaultValidator
implements ICssDeclarationValidator {
    protected final Map<String, ICssDeclarationValidator> defaultValidators;

    public CssDefaultValidator() {
        MultiTypeDeclarationValidator colorCommonValidator = new MultiTypeDeclarationValidator(new CssEnumValidator("transparent", "initial", "inherit", "currentcolor"), new CssColorValidator());
        CssEnumValidator normalValidator = new CssEnumValidator("normal");
        CssEnumValidator relativeSizeValidator = new CssEnumValidator("larger", "smaller");
        CssEnumValidator absoluteSizeValidator = new CssEnumValidator(new String[0]);
        absoluteSizeValidator.addAllowedValues(CommonCssConstants.FONT_ABSOLUTE_SIZE_KEYWORDS_VALUES.keySet());
        CssEnumValidator inheritInitialUnsetValidator = new CssEnumValidator("inherit", "initial", "unset");
        this.defaultValidators = new HashMap<String, ICssDeclarationValidator>();
        this.defaultValidators.put("background-color", colorCommonValidator);
        this.defaultValidators.put("color", colorCommonValidator);
        this.defaultValidators.put("border-color", colorCommonValidator);
        this.defaultValidators.put("border-bottom-color", colorCommonValidator);
        this.defaultValidators.put("border-top-color", colorCommonValidator);
        this.defaultValidators.put("border-left-color", colorCommonValidator);
        this.defaultValidators.put("border-right-color", colorCommonValidator);
        this.defaultValidators.put("float", new SingleTypeDeclarationValidator(new CssEnumValidator("left", "right", "none", "inherit", "center")));
        this.defaultValidators.put("page-break-before", new SingleTypeDeclarationValidator(new CssEnumValidator("auto", "always", "avoid", "left", "right")));
        this.defaultValidators.put("page-break-after", new SingleTypeDeclarationValidator(new CssEnumValidator("auto", "always", "avoid", "left", "right")));
        this.defaultValidators.put("quotes", new MultiTypeDeclarationValidator(new CssEnumValidator("initial", "inherit", "none"), new CssQuotesValidator()));
        this.defaultValidators.put("transform", new SingleTypeDeclarationValidator(new CssTransformValidator()));
        this.defaultValidators.put("font-size", new MultiTypeDeclarationValidator(new CssLengthValueValidator(false), new CssPercentageValueValidator(false), relativeSizeValidator, absoluteSizeValidator));
        this.defaultValidators.put("word-spacing", new MultiTypeDeclarationValidator(new CssLengthValueValidator(true), normalValidator));
        this.defaultValidators.put("letter-spacing", new MultiTypeDeclarationValidator(new CssLengthValueValidator(true), normalValidator));
        this.defaultValidators.put("text-indent", new MultiTypeDeclarationValidator(new CssLengthValueValidator(true), new CssPercentageValueValidator(true), new CssEnumValidator("each-line", "hanging", "hanging each-line")));
        this.defaultValidators.put("line-height", new MultiTypeDeclarationValidator(new CssNumberValueValidator(false), new CssLengthValueValidator(false), new CssPercentageValueValidator(false), normalValidator, inheritInitialUnsetValidator));
        this.defaultValidators.put("column-gap", new MultiTypeDeclarationValidator(new CssLengthValueValidator(false), new CssPercentageValueValidator(false), normalValidator, inheritInitialUnsetValidator));
        this.defaultValidators.put("row-gap", new MultiTypeDeclarationValidator(new CssLengthValueValidator(false), new CssPercentageValueValidator(false), normalValidator, inheritInitialUnsetValidator));
        this.defaultValidators.put("flex-grow", new MultiTypeDeclarationValidator(new CssNumberValueValidator(false), inheritInitialUnsetValidator));
        this.defaultValidators.put("flex-shrink", new MultiTypeDeclarationValidator(new CssNumberValueValidator(false), inheritInitialUnsetValidator));
        CssEnumValidator flexBasisEnumValidator = new CssEnumValidator("auto", "content", "min-content", "max-content", "fit-content");
        this.defaultValidators.put("flex-basis", new MultiTypeDeclarationValidator(new CssLengthValueValidator(false), new CssPercentageValueValidator(false), flexBasisEnumValidator));
        this.defaultValidators.put("background-repeat", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-repeat")));
        this.defaultValidators.put("background-image", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-image")));
        this.defaultValidators.put("background-position-x", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-position-x")));
        this.defaultValidators.put("background-position-y", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-position-y")));
        this.defaultValidators.put("background-size", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-size")));
        this.defaultValidators.put("background-clip", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-clip")));
        this.defaultValidators.put("background-origin", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-origin")));
        this.defaultValidators.put("background-blend-mode", new SingleTypeDeclarationValidator(new ArrayDataTypeValidator(new CssBlendModeValidator())));
        this.defaultValidators.put("overflow-wrap", new MultiTypeDeclarationValidator(new CssEnumValidator("anywhere", "break-word"), normalValidator, inheritInitialUnsetValidator));
        this.defaultValidators.put("word-break", new MultiTypeDeclarationValidator(new CssEnumValidator("break-all", "keep-all", "break-word"), normalValidator, inheritInitialUnsetValidator));
        this.defaultValidators.put("flex-direction", new MultiTypeDeclarationValidator(new CssEnumValidator("row", "row-reverse", "column", "column-reverse"), inheritInitialUnsetValidator));
        this.defaultValidators.put("flex-wrap", new MultiTypeDeclarationValidator(new CssEnumValidator("nowrap", "wrap", "wrap-reverse"), inheritInitialUnsetValidator));
        this.defaultValidators.put("align-items", new MultiTypeDeclarationValidator(normalValidator, new CssEnumValidator(Arrays.asList("baseline"), Arrays.asList("first", "last")), new CssEnumValidator(Arrays.asList("stretch", "center", "start", "end", "flex-start", "flex-end", "self-start", "self-end"), Arrays.asList("safe", "unsafe")), inheritInitialUnsetValidator));
        this.defaultValidators.put("justify-content", new MultiTypeDeclarationValidator(new CssEnumValidator(Arrays.asList("space-around", "space-between", "space-evenly", "stretch", "normal", "left", "right")), new CssEnumValidator(Arrays.asList("center", "start", "flex-start", "self-start", "end", "flex-end", "self-end"), Arrays.asList("safe", "unsafe")), inheritInitialUnsetValidator));
        this.defaultValidators.put("justify-items", new MultiTypeDeclarationValidator(normalValidator, new CssEnumValidator(Arrays.asList("baseline"), Arrays.asList("first", "last")), new CssEnumValidator(Arrays.asList("stretch", "center", "start", "end", "flex-start", "flex-end", "self-start", "self-end", "left", "right"), Arrays.asList("safe", "unsafe")), new CssEnumValidator("legacy", "legacy left", "legacy right", "legacy center"), inheritInitialUnsetValidator));
    }

    @Override
    public boolean isValid(CssDeclaration declaration) {
        ICssDeclarationValidator validator = this.defaultValidators.get(declaration.getProperty());
        return validator == null || validator.isValid(declaration);
    }
}

