/*
    This file is part of the iText (R) project.
    Copyright (c) 1998-2022 iText Group NV
    Authors: Bruno Lowagie, Paulo Soares, et al.
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License version 3
    as published by the Free Software Foundation with the addition of the
    following permission added to Section 15 as permitted in Section 7(a):
    FOR ANY PART OF THE COVERED WORK IN WHICH THE COPYRIGHT IS OWNED BY
    ITEXT GROUP. ITEXT GROUP DISCLAIMS THE WARRANTY OF NON INFRINGEMENT
    OF THIRD PARTY RIGHTS
    
    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Affero General Public License for more details.
    You should have received a copy of the GNU Affero General Public License
    along with this program; if not, see http://www.gnu.org/licenses or write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA, 02110-1301 USA, or download the license from the following URL:
    http://itextpdf.com/terms-of-use/
    
    The interactive user interfaces in modified source and object code versions
    of this program must display Appropriate Legal Notices, as required under
    Section 5 of the GNU Affero General Public License.
    
    In accordance with Section 7(b) of the GNU Affero General Public License,
    a covered work must retain the producer line in every PDF that is created
    or manipulated using iText.
    
    You can be released from the requirements of the license by purchasing
    a commercial license. Buying such a license is mandatory as soon as you
    develop commercial activities involving the iText software without
    disclosing the source code of your own applications.
    These activities include: offering paid services to customers as an ASP,
    serving PDFs on the fly in a web application, shipping iText with a closed
    source product.
    
    For more information, please contact iText Software Corp. at this
    address: sales@itextpdf.com
 */
package com.itextpdf.styledxmlparser.css;

/**
 * Class containing possible CSS rule names.
 */
public final class CssRuleName {

    /**
     * Creates a new {@link CssRuleName} instance.
     */
    private CssRuleName() {
    }

    /** The Constant BOTTOM_CENTER. */
    public static final String BOTTOM_CENTER = "bottom-center";
    
    /** The Constant BOTTOM_LEFT. */
    public static final String BOTTOM_LEFT = "bottom-left";
    
    /** The Constant BOTTOM_LEFT_CORNER. */
    public static final String BOTTOM_LEFT_CORNER = "bottom-left-corner";
    
    /** The Constant BOTTOM_RIGHT. */
    public static final String BOTTOM_RIGHT = "bottom-right";
    
    /** The Constant BOTTOM_RIGHT_CORNER. */
    public static final String BOTTOM_RIGHT_CORNER = "bottom-right-corner";
    
    /** The Constant LEFT_BOTTOM. */
    public static final String LEFT_BOTTOM = "left-bottom";
    
    /** The Constant LEFT_MIDDLE. */
    public static final String LEFT_MIDDLE = "left-middle";
    
    /** The Constant LEFT_TOP. */
    public static final String LEFT_TOP = "left-top";
    
    /** The Constant FONT_FACE. */
    public static final String FONT_FACE = "font-face";
    
    /** The Constant MEDIA. */
    public static final String MEDIA = "media";
    
    /** The Constant PAGE. */
    public static final String PAGE = "page";
    
    /** The Constant RIGHT_BOTTOM. */
    public static final String RIGHT_BOTTOM = "right-bottom";
    
    /** The Constant RIGHT_MIDDLE. */
    public static final String RIGHT_MIDDLE = "right-middle";
    
    /** The Constant RIGHT_TOP. */
    public static final String RIGHT_TOP = "right-top";
    
    /** The Constant TOP_CENTER. */
    public static final String TOP_CENTER = "top-center";
    
    /** The Constant TOP_LEFT. */
    public static final String TOP_LEFT = "top-left";
    
    /** The Constant TOP_LEFT_CORNER. */
    public static final String TOP_LEFT_CORNER = "top-left-corner";
    
    /** The Constant TOP_RIGHT. */
    public static final String TOP_RIGHT = "top-right";
    
    /** The Constant TOP_RIGHT_CORNER. */
    public static final String TOP_RIGHT_CORNER = "top-right-corner";
}
