/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.jsoup.helper;

import com.itextpdf.styledxmlparser.jsoup.helper.Validate;
import java.io.InputStream;

public class KeyVal {
    private String key;
    private String value;
    private InputStream stream;

    public static KeyVal create(String key, String value) {
        return new KeyVal().key(key).value(value);
    }

    public static KeyVal create(String key, String filename, InputStream stream) {
        return new KeyVal().key(key).value(filename).inputStream(stream);
    }

    private KeyVal() {
    }

    public KeyVal key(String key) {
        Validate.notEmpty(key, "Data key must not be empty");
        this.key = key;
        return this;
    }

    public String key() {
        return this.key;
    }

    public KeyVal value(String value) {
        Validate.notNull(value, "Data value must not be null");
        this.value = value;
        return this;
    }

    public String value() {
        return this.value;
    }

    public KeyVal inputStream(InputStream inputStream) {
        Validate.notNull(this.value, "Data input stream must not be null");
        this.stream = inputStream;
        return this;
    }

    public InputStream inputStream() {
        return this.stream;
    }

    public boolean hasInputStream() {
        return this.stream != null;
    }

    public String toString() {
        return this.key + "=" + this.value;
    }
}

