/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.widget.light.domain.event.disruptor;

import com.iohao.game.widget.light.domain.event.DisruptorManager;
import com.iohao.game.widget.light.domain.event.DomainEventContextParam;
import com.iohao.game.widget.light.domain.event.disruptor.ConsumeEventHandler;
import com.iohao.game.widget.light.domain.event.disruptor.DisruptorCreate;
import com.iohao.game.widget.light.domain.event.disruptor.EventDisruptor;
import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDisruptorCreate
implements DisruptorCreate {
    private static final Logger log = LoggerFactory.getLogger(DefaultDisruptorCreate.class);
    static final AtomicInteger THREAD_INIT_NUMBER = new AtomicInteger(1);

    @Override
    public Disruptor<EventDisruptor> createDisruptor(Class<?> topic, DomainEventContextParam param) {
        int ringBufferSize = param.getRingBufferSize();
        ProducerType producerType = param.getProducerType();
        WaitStrategy waitStrategy = param.getWaitStrategy();
        ThreadFactory threadFactory = this.createThreadFactory(topic);
        return new Disruptor(EventDisruptor::new, ringBufferSize, threadFactory, producerType, waitStrategy);
    }

    private ThreadFactory createThreadFactory(Class<?> topic) {
        return r -> {
            String domainEventHandlerName = this.getName(r);
            ArrayList<String> nameParamList = new ArrayList<String>();
            nameParamList.add(DisruptorManager.me().getThreadNamePrefix());
            nameParamList.add(topic.getSimpleName());
            nameParamList.add(domainEventHandlerName);
            nameParamList.add(String.valueOf(THREAD_INIT_NUMBER.getAndIncrement()));
            String threadName = String.join((CharSequence)"-", nameParamList);
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName(threadName);
            return thread;
        };
    }

    private String getName(Runnable r) {
        String domainEventHandlerName = "";
        if (r instanceof BatchEventProcessor) {
            BatchEventProcessor eventProcessor = (BatchEventProcessor)r;
            try {
                Field eventHandler = BatchEventProcessor.class.getDeclaredField("eventHandler");
                eventHandler.setAccessible(true);
                Object o = eventHandler.get(eventProcessor);
                if (o instanceof ConsumeEventHandler) {
                    ConsumeEventHandler consumeEventHandler = (ConsumeEventHandler)o;
                    domainEventHandlerName = consumeEventHandler.eventHandler().getName();
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return domainEventHandlerName;
        }
        return domainEventHandlerName;
    }
}

