/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.widget.light.domain.event;

import com.iohao.game.widget.light.domain.event.DisruptorManager;
import com.iohao.game.widget.light.domain.event.disruptor.DomainEventSource;
import com.iohao.game.widget.light.domain.event.disruptor.EventDisruptor;
import com.iohao.game.widget.light.domain.event.message.Topic;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.Objects;

public final class DomainEventPublish {
    public static void send(DomainEventSource domainSource) {
        DomainEventPublish.publishDomainEvent(domainSource, domainSource.getTopic(), true);
    }

    public static void send(Object domainSource) {
        if (domainSource instanceof DomainEventSource) {
            DomainEventSource domainEventSource = (DomainEventSource)domainSource;
            DomainEventPublish.send(domainEventSource);
        } else {
            Class<?> topic = domainSource instanceof Topic ? ((Topic)domainSource).getTopic() : domainSource.getClass();
            DomainEventPublish.publishDomainEvent(domainSource, topic, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void publishDomainEvent(Object domainSource, Class<?> topic, boolean eventSource) {
        Disruptor<EventDisruptor> disruptor = DisruptorManager.me().getDisruptor(topic);
        if (Objects.isNull(disruptor)) {
            throw new NullPointerException("\u6ca1\u6709\u914d\u7f6e\u5904\u7406 : " + topic + " \u7684\u9886\u57df\u4e8b\u4ef6. \u8bf7\u914d\u7f6e");
        }
        RingBuffer ringBuffer = disruptor.getRingBuffer();
        long sequence = ringBuffer.next();
        try {
            EventDisruptor eventDisruptor = (EventDisruptor)ringBuffer.get(sequence);
            if (eventSource) {
                eventDisruptor.setDomainEventSource((DomainEventSource)domainSource);
            } else {
                eventDisruptor.setValue(domainSource);
            }
        }
        finally {
            ringBuffer.publish(sequence);
        }
    }

    private DomainEventPublish() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

