/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.widget.light.domain.event;

import com.iohao.game.widget.light.domain.event.DisruptorManager;
import com.iohao.game.widget.light.domain.event.DomainEventContextParam;
import com.iohao.game.widget.light.domain.event.disruptor.ConsumeEventHandler;
import com.iohao.game.widget.light.domain.event.disruptor.DisruptorCreate;
import com.iohao.game.widget.light.domain.event.disruptor.EventDisruptor;
import com.iohao.game.widget.light.domain.event.message.DomainEventHandler;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.dsl.Disruptor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainEventContext {
    private static final Logger log = LoggerFactory.getLogger(DomainEventContext.class);
    final DomainEventContextParam param;

    public DomainEventContext(DomainEventContextParam param) {
        this.param = param;
    }

    public boolean startup() {
        AtomicBoolean init = this.param.getInit();
        if (init.get()) {
            return init.get();
        }
        init.set(true);
        DisruptorCreate disruptorCreate = this.param.disruptorCreate;
        Set<DomainEventHandler<?>> domainEventHandlerSet = this.param.domainEventHandlerSet;
        domainEventHandlerSet.parallelStream().collect(Collectors.groupingBy(o -> {
            Type type = ((ParameterizedType)o.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
            try {
                String name = type.getTypeName();
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        })).forEach((topic, eventHandlers) -> {
            Disruptor<EventDisruptor> disruptor = disruptorCreate.createDisruptor((Class<?>)topic, this.param);
            DisruptorManager.me().put((Class<?>)topic, disruptor);
            if (Objects.nonNull(this.param.exceptionHandler)) {
                disruptor.setDefaultExceptionHandler(this.param.exceptionHandler);
            }
            eventHandlers.forEach(eventHandler -> disruptor.handleEventsWith(new EventHandler[]{new ConsumeEventHandler((DomainEventHandler<?>)eventHandler)}));
        });
        DisruptorManager.me().forEach(Disruptor::start);
        domainEventHandlerSet.clear();
        return init.get();
    }

    public boolean stop() {
        DisruptorManager.me().listDisruptor().removeIf(disruptor -> {
            disruptor.shutdown();
            return true;
        });
        return true;
    }
}

