/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.client.processor.connection;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventProcessor;
import com.iohao.game.bolt.broker.core.aware.BrokerClientItemAware;
import com.iohao.game.bolt.broker.core.client.BrokerClientItem;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;

public class ConnectEventClientProcessor
implements ConnectionEventProcessor,
BrokerClientItemAware {
    static final Logger log = IoGameLoggerFactory.getLoggerConnection();
    private final AtomicBoolean connected = new AtomicBoolean();
    private final AtomicInteger connectTimes = new AtomicInteger();
    private Connection connection;
    private String remoteAddress;
    private final CountDownLatch latch = new CountDownLatch(1);
    static final LongAdder count = new LongAdder();
    BrokerClientItem brokerClientItem;

    public void onEvent(String remoteAddress, Connection conn) {
        Objects.nonNull(remoteAddress);
        this.doCheckConnection(conn);
        this.remoteAddress = remoteAddress;
        this.connection = conn;
        this.connected.set(true);
        this.connectTimes.incrementAndGet();
        this.latch.countDown();
        this.brokerClientItem.setConnection(conn);
        log.debug("~~~~~~~~~~~ client connect: {}", (Object)this.latch);
        count.increment();
        log.debug("~~~~~~~~~~~ client count: {}", (Object)count);
    }

    private void doCheckConnection(Connection conn) {
        Objects.requireNonNull(conn);
        Objects.requireNonNull(conn.getPoolKeys());
        Objects.requireNonNull(conn.getChannel());
        Objects.requireNonNull(conn.getUrl());
        Objects.requireNonNull((Connection)conn.getChannel().attr(Connection.CONNECTION).get());
    }

    public boolean isConnected() throws InterruptedException {
        this.latch.await();
        return this.connected.get();
    }

    public int getConnectTimes() throws InterruptedException {
        this.latch.await();
        return this.connectTimes.get();
    }

    public Connection getConnection() throws InterruptedException {
        this.latch.await();
        return this.connection;
    }

    public String getRemoteAddress() throws InterruptedException {
        this.latch.await();
        return this.remoteAddress;
    }

    public void reset() {
        this.connectTimes.set(0);
        this.connected.set(false);
        this.connection = null;
    }

    public void setBrokerClientItem(BrokerClientItem brokerClientItem) {
        this.brokerClientItem = brokerClientItem;
    }
}

