/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.client.processor.connection;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventProcessor;
import com.iohao.game.bolt.broker.core.aware.BrokerClientItemAware;
import com.iohao.game.bolt.broker.core.client.BrokerClient;
import com.iohao.game.bolt.broker.core.client.BrokerClientItem;
import com.iohao.game.bolt.broker.core.client.BrokerClientManager;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class CloseConnectEventClientProcessor
implements ConnectionEventProcessor,
BrokerClientItemAware {
    static final Logger log = IoGameLoggerFactory.getLoggerConnection();
    private final AtomicBoolean dicConnected = new AtomicBoolean();
    private final AtomicInteger disConnectTimes = new AtomicInteger();
    BrokerClientItem brokerClientItem;

    public void onEvent(String remoteAddress, Connection conn) {
        Objects.requireNonNull(conn);
        this.dicConnected.set(true);
        this.disConnectTimes.incrementAndGet();
        log.debug("\u7f51\u5173\u65ad\u5f00 remoteAddress : {}", (Object)remoteAddress);
        BrokerClient brokerClient = this.brokerClientItem.getBrokerClient();
        BrokerClientManager brokerClientManager = brokerClient.getBrokerClientManager();
        log.debug("brokerClientItems : {}", (Object)brokerClientManager.countActiveItem());
        brokerClientManager.remove(this.brokerClientItem);
        log.debug("brokerClientItems : {}", (Object)brokerClientManager.countActiveItem());
    }

    public boolean isDisConnected() {
        return this.dicConnected.get();
    }

    public int getDisConnectTimes() {
        return this.disConnectTimes.get();
    }

    public void reset() {
        this.disConnectTimes.set(0);
        this.dicConnected.set(false);
    }

    public void setBrokerClientItem(BrokerClientItem brokerClientItem) {
        this.brokerClientItem = brokerClientItem;
    }
}

