/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.client.processor;

import com.alipay.remoting.BizContext;
import com.alipay.remoting.rpc.protocol.SyncUserProcessor;
import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.flow.FlowContext;
import com.iohao.game.action.skeleton.core.flow.attr.FlowAttr;
import com.iohao.game.action.skeleton.protocol.RequestMessage;
import com.iohao.game.action.skeleton.protocol.SyncRequestMessage;
import com.iohao.game.bolt.broker.core.aware.BrokerClientAware;
import com.iohao.game.bolt.broker.core.aware.UserProcessorExecutorAware;
import com.iohao.game.bolt.broker.core.client.BrokerClient;
import com.iohao.game.bolt.broker.core.common.processor.hook.ClientProcessorHooks;
import com.iohao.game.bolt.broker.core.common.processor.hook.RequestMessageClientProcessorHook;
import java.util.concurrent.Executor;

public class SyncRequestMessageClientProcessor
extends SyncUserProcessor<SyncRequestMessage>
implements BrokerClientAware,
UserProcessorExecutorAware {
    BrokerClient brokerClient;
    RequestMessageClientProcessorHook requestMessageClientProcessorHook;
    Executor userProcessorExecutor;

    public Object handleRequest(BizContext bizCtx, SyncRequestMessage request) throws Exception {
        BrokerClient brokerClient = this.brokerClient;
        BarSkeleton barSkeleton = brokerClient.getBarSkeleton();
        FlowContext flowContext = barSkeleton.getFlowContextFactory().createFlowContext().setRequest((RequestMessage)request).setExecuteActionAfter(false);
        flowContext.option(FlowAttr.brokerClientContext, (Object)brokerClient);
        flowContext.option(FlowAttr.logicServerId, (Object)brokerClient.getId());
        flowContext.option(FlowAttr.logicServerTag, (Object)brokerClient.getTag());
        barSkeleton.handle(flowContext);
        ActionCommand actionCommand = flowContext.getActionCommand();
        if (actionCommand.getActionMethodReturnInfo().isVoid()) {
            return null;
        }
        return flowContext.getResponse();
    }

    public String interest() {
        return SyncRequestMessage.class.getName();
    }

    public void setBrokerClient(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
        ClientProcessorHooks clientProcessorHooks = brokerClient.getClientProcessorHooks();
        this.requestMessageClientProcessorHook = clientProcessorHooks.getRequestMessageClientProcessorHook();
    }

    public Executor getExecutor() {
        return this.userProcessorExecutor;
    }

    public void setUserProcessorExecutor(Executor userProcessorExecutor) {
        this.userProcessorExecutor = userProcessorExecutor;
    }
}

