/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.client.processor;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.flow.FlowContext;
import com.iohao.game.action.skeleton.core.flow.attr.FlowAttr;
import com.iohao.game.action.skeleton.protocol.RequestMessage;
import com.iohao.game.bolt.broker.client.action.skeleton.BoltChannelContext;
import com.iohao.game.bolt.broker.core.aware.BrokerClientAware;
import com.iohao.game.bolt.broker.core.client.BrokerClient;
import com.iohao.game.bolt.broker.core.common.AbstractAsyncUserProcessor;
import com.iohao.game.bolt.broker.core.common.processor.hook.ClientProcessorHooks;
import com.iohao.game.bolt.broker.core.common.processor.hook.RequestMessageClientProcessorHook;

public class RequestMessageClientProcessor
extends AbstractAsyncUserProcessor<RequestMessage>
implements BrokerClientAware {
    BrokerClient brokerClient;
    RequestMessageClientProcessorHook requestMessageClientProcessorHook;

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, RequestMessage request) {
        BrokerClient brokerClient = this.brokerClient;
        BarSkeleton barSkeleton = brokerClient.getBarSkeleton();
        FlowContext flowContext = barSkeleton.getFlowContextFactory().createFlowContext().setRequest(request);
        BoltChannelContext channelContext = new BoltChannelContext(asyncCtx);
        flowContext.option(FlowAttr.channelContext, (Object)channelContext);
        flowContext.option(FlowAttr.brokerClientContext, (Object)brokerClient);
        flowContext.option(FlowAttr.logicServerId, (Object)brokerClient.getId());
        flowContext.option(FlowAttr.logicServerTag, (Object)brokerClient.getTag());
        this.requestMessageClientProcessorHook.processLogic(barSkeleton, flowContext);
    }

    public void setBrokerClient(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
        ClientProcessorHooks clientProcessorHooks = brokerClient.getClientProcessorHooks();
        this.requestMessageClientProcessorHook = clientProcessorHooks.getRequestMessageClientProcessorHook();
    }

    public String interest() {
        return RequestMessage.class.getName();
    }
}

