/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.client.processor;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.iohao.game.action.skeleton.protocol.processor.ExtRequestMessage;
import com.iohao.game.action.skeleton.protocol.processor.ExtResponseMessage;
import com.iohao.game.bolt.broker.core.aware.BrokerClientAware;
import com.iohao.game.bolt.broker.core.client.BrokerClient;
import com.iohao.game.bolt.broker.core.common.AbstractAsyncUserProcessor;
import com.iohao.game.bolt.broker.core.ext.ExtRegion;
import com.iohao.game.bolt.broker.core.ext.ExtRegionContext;
import com.iohao.game.bolt.broker.core.ext.ExtRegions;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import java.util.Objects;
import org.slf4j.Logger;

public class ExtRequestMessageClientProcessor
extends AbstractAsyncUserProcessor<ExtRequestMessage>
implements BrokerClientAware {
    static final Logger log = IoGameLoggerFactory.getLoggerCommon();
    BrokerClient brokerClient;

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, ExtRequestMessage request) {
        int sourceClientId = request.getSourceClientId();
        ExtRegion extRegion = ExtRegions.me().getExtRegion(sourceClientId);
        if (Objects.isNull(extRegion)) {
            log.warn("ExtRegion \u4e0d\u5b58\u5728 {}", (Object)request);
            return;
        }
        ExtRegionContext extRegionContext = new ExtRegionContext().setBrokerClient(this.brokerClient).setRequest(request);
        ExtResponseMessage responseMessage = extRegion.request(extRegionContext);
        if (Objects.isNull(responseMessage)) {
            return;
        }
        responseMessage.setSourceClientId(sourceClientId);
        try {
            this.brokerClient.oneway((Object)responseMessage);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String interest() {
        return ExtRequestMessage.class.getName();
    }

    public void setBrokerClient(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
    }
}

