/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.client.processor;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.rpc.protocol.AsyncUserProcessor;
import com.iohao.game.bolt.broker.core.aware.BrokerClientAware;
import com.iohao.game.bolt.broker.core.client.BrokerClient;
import com.iohao.game.bolt.broker.core.client.BrokerClientManager;
import com.iohao.game.bolt.broker.core.message.BrokerClusterMessage;
import com.iohao.game.bolt.broker.core.message.BrokerMessage;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class BrokerClusterMessageClientProcessor
extends AsyncUserProcessor<BrokerClusterMessage>
implements BrokerClientAware {
    static final Logger log = IoGameLoggerFactory.getLoggerCluster();
    BrokerClient brokerClient;

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, BrokerClusterMessage message) {
        if (log.isDebugEnabled()) {
            log.debug("==\u63a5\u6536\u6765\u81ea\u7f51\u5173\u7684\u96c6\u7fa4\u6d88\u606f {} {}", (Object)message.getBrokerMessageList().size(), (Object)message);
        }
        BrokerClientManager brokerClientManager = this.brokerClient.getBrokerClientManager();
        Set keySet = brokerClientManager.keySet();
        List brokerMessageList = message.getBrokerMessageList();
        for (BrokerMessage brokerMessage : brokerMessageList) {
            String address = brokerMessage.getAddress();
            keySet.remove(address);
            boolean contains = brokerClientManager.contains(address);
            if (contains) continue;
            log.debug("\u96c6\u7fa4\u6709\u65b0\u7684\u673a\u5668 address : {}", (Object)address);
            brokerClientManager.register(address);
        }
        for (String address : keySet) {
            if (address.contains("127.0.0.1")) continue;
            brokerClientManager.remove(address);
        }
    }

    public String interest() {
        return BrokerClusterMessage.class.getName();
    }

    public void setBrokerClient(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
    }
}

