/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.client;

import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.bolt.broker.client.BrokerClientStartup;
import com.iohao.game.bolt.broker.client.processor.BrokerClusterMessageClientProcessor;
import com.iohao.game.bolt.broker.client.processor.ExtRequestMessageClientProcessor;
import com.iohao.game.bolt.broker.client.processor.RequestBrokerClientModuleMessageClientProcessor;
import com.iohao.game.bolt.broker.client.processor.RequestMessageClientProcessor;
import com.iohao.game.bolt.broker.client.processor.SyncRequestMessageClientProcessor;
import com.iohao.game.bolt.broker.client.processor.connection.CloseConnectEventClientProcessor;
import com.iohao.game.bolt.broker.client.processor.connection.ConnectEventClientProcessor;
import com.iohao.game.bolt.broker.client.processor.connection.ConnectFailedEventClientProcessor;
import com.iohao.game.bolt.broker.client.processor.connection.ExceptionConnectEventClientProcessor;
import com.iohao.game.bolt.broker.core.client.BrokerAddress;
import com.iohao.game.bolt.broker.core.client.BrokerClientBuilder;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class AbstractBrokerClientStartup
implements BrokerClientStartup {
    private BrokerAddress brokerAddress;
    private BarSkeleton barSkeleton;
    private BrokerClientBuilder brokerClientBuilder;

    @Override
    public void connectionEventProcessor(BrokerClientBuilder brokerClientBuilder) {
        Supplier<ConnectionEventProcessor> connectProcessorSupplier = ConnectEventClientProcessor::new;
        Supplier<ConnectionEventProcessor> closeConnectProcessorSupplier = CloseConnectEventClientProcessor::new;
        Supplier<ConnectionEventProcessor> connectFailedProcessorSupplier = ConnectFailedEventClientProcessor::new;
        Supplier<ConnectionEventProcessor> exceptionConnectProcessorSupplier = ExceptionConnectEventClientProcessor::new;
        brokerClientBuilder.addConnectionEventProcessor(ConnectionEventType.CONNECT, connectProcessorSupplier).addConnectionEventProcessor(ConnectionEventType.CLOSE, closeConnectProcessorSupplier).addConnectionEventProcessor(ConnectionEventType.CONNECT_FAILED, connectFailedProcessorSupplier).addConnectionEventProcessor(ConnectionEventType.EXCEPTION, exceptionConnectProcessorSupplier);
    }

    @Override
    public void registerUserProcessor(BrokerClientBuilder brokerClientBuilder) {
        Supplier<UserProcessor> requestBrokerClientModuleSupplier = RequestBrokerClientModuleMessageClientProcessor::new;
        Supplier<UserProcessor> brokerClusterMessageProcessorSupplier = BrokerClusterMessageClientProcessor::new;
        Supplier<UserProcessor> extRequestMessageProcessorSupplier = ExtRequestMessageClientProcessor::new;
        Supplier<UserProcessor> requestMessageClientSupplier = RequestMessageClientProcessor::new;
        Supplier<UserProcessor> syncRequestMessageClientSupplier = SyncRequestMessageClientProcessor::new;
        brokerClientBuilder.registerUserProcessor(requestBrokerClientModuleSupplier).registerUserProcessor(brokerClusterMessageProcessorSupplier).registerUserProcessor(extRequestMessageProcessorSupplier).registerUserProcessor(requestMessageClientSupplier).registerUserProcessor(syncRequestMessageClientSupplier);
    }

    BrokerClientBuilder initConfig() {
        this.barSkeleton = this.createBarSkeleton();
        this.brokerAddress = this.createBrokerAddress();
        if (Objects.isNull(this.brokerClientBuilder)) {
            this.brokerClientBuilder = this.createBrokerClientBuilder();
        }
        Objects.requireNonNull(this.brokerClientBuilder, "brokerClient \u6784\u5efa\u5668\u5fc5\u987b\u8981\u6709");
        this.brokerClientBuilder.barSkeleton(this.barSkeleton).brokerAddress(this.brokerAddress);
        this.connectionEventProcessor(this.brokerClientBuilder);
        this.registerUserProcessor(this.brokerClientBuilder);
        this.experiment();
        return this.brokerClientBuilder;
    }

    private void experiment() {
    }

    public AbstractBrokerClientStartup setBrokerAddress(BrokerAddress brokerAddress) {
        this.brokerAddress = brokerAddress;
        return this;
    }

    public AbstractBrokerClientStartup setBarSkeleton(BarSkeleton barSkeleton) {
        this.barSkeleton = barSkeleton;
        return this;
    }

    public AbstractBrokerClientStartup setBrokerClientBuilder(BrokerClientBuilder brokerClientBuilder) {
        this.brokerClientBuilder = brokerClientBuilder;
        return this;
    }
}

