/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common.webserver;

import com.igumnov.common.Log;
import com.igumnov.common.webserver.LoginServiceInterface;
import com.igumnov.common.webserver.WebUser;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.security.Credential;

public class LoginServiceHandler
implements LoginService {
    private IdentityService identityService = new DefaultIdentityService();
    private LoginServiceInterface loginServiceInterface;

    public LoginServiceHandler(LoginServiceInterface loginServiceInterface) {
        this.loginServiceInterface = loginServiceInterface;
    }

    public String getName() {
        return "Custom";
    }

    public UserIdentity login(String userName, Object credentials, ServletRequest request) {
        Log.debug("UserIdentity login called");
        WebUser user = this.loginServiceInterface.getUser(userName);
        if (user == null) {
            return null;
        }
        String userPassword = user.getPassword();
        String[] roles = user.getRoles();
        MappedLoginService.KnownUser userPrincipal = new MappedLoginService.KnownUser(userName, Credential.getCredential((String)userPassword));
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)userPrincipal);
        subject.getPrivateCredentials().add(Credential.getCredential((String)credentials.toString()));
        if (roles != null) {
            for (String role : roles) {
                subject.getPrincipals().add((Principal)new MappedLoginService.RolePrincipal(role));
            }
        }
        subject.setReadOnly();
        UserIdentity identity = this.identityService.newUserIdentity(subject, (Principal)userPrincipal, roles);
        MappedLoginService.UserPrincipal principal = (MappedLoginService.UserPrincipal)identity.getUserPrincipal();
        if (principal.authenticate(credentials)) {
            return identity;
        }
        return null;
    }

    public boolean validate(UserIdentity user) {
        Log.debug("validate UserIdentity called");
        WebUser u = this.loginServiceInterface.getUser(user.getUserPrincipal().getName());
        return u != null;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService service) {
        this.identityService = service;
    }

    public void logout(UserIdentity user) {
    }
}

