/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common.webserver;

import com.igumnov.common.webserver.ControllerContext;
import com.igumnov.common.webserver.ControllerInterface;
import com.igumnov.common.webserver.LocaleInterceptorInterface;
import com.igumnov.common.webserver.WebServerException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;

public class ControllerHandler
extends HttpServlet {
    private HashMap<String, TemplateEngine> templateEngines;
    private ControllerInterface controller;
    private LocaleInterceptorInterface localeInterceptor;

    public ControllerHandler(HashMap<String, TemplateEngine> engines, LocaleInterceptorInterface interceptor, ControllerInterface c) {
        this.templateEngines = engines;
        this.localeInterceptor = interceptor;
        this.controller = c;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        HashMap<String, Object> model = new HashMap<String, Object>();
        String templateName = null;
        int status = 200;
        String lang = null;
        try {
            templateName = this.controller.process(request, response, model);
            if (templateName.startsWith("redirect:")) {
                response.sendRedirect(response.encodeRedirectURL(templateName.substring(9)));
                return;
            }
            lang = this.localeInterceptor.locale(request, response);
        }
        catch (WebServerException e) {
            status = 400;
        }
        ControllerContext context = new ControllerContext(model, request.getServletContext());
        TemplateEngine templateEngine = this.templateEngines.get(lang);
        String ret = templateEngine.process(templateName, (IContext)context);
        response.setContentType("text/html; charset=utf-8");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(status);
        PrintWriter out = response.getWriter();
        out.write(ret);
    }
}

